/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.config;

import com.stratio.deep.commons.config.BaseConfig;
import com.stratio.deep.commons.filter.Filter;
import com.stratio.deep.commons.utils.Pair;
import com.stratio.deep.commons.utils.Utils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ExtractorConfig<T>
extends BaseConfig<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8418401138615339258L;
    private Map<String, Serializable> values = new HashMap<String, Serializable>();

    public ExtractorConfig(Class<T> t) {
        super(t);
    }

    public ExtractorConfig() {
    }

    public Map<String, Serializable> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Serializable> values) {
        this.values = values;
    }

    public ExtractorConfig<T> putValue(String key, Serializable value) {
        this.values.put(key, value);
        return this;
    }

    @Override
    public String getExtractorImplClassName() {
        return this.extractorImplClassName;
    }

    @Override
    public void setExtractorImplClassName(String extractorImplClassName) {
        this.extractorImplClassName = extractorImplClassName;
    }

    public String getString(String key) {
        return this.getValue(String.class, key);
    }

    public Integer getInteger(String key) {
        try {
            return this.getValue(Integer.class, key);
        }
        catch (ClassCastException e) {
            return Integer.parseInt(this.getString(key));
        }
    }

    public Boolean getBoolean(String key) {
        return this.getValue(Boolean.class, key);
    }

    public String[] getStringArray(String key) {
        try {
            return this.getValue(String[].class, key);
        }
        catch (ClassCastException e) {
            return new String[]{this.getString(key)};
        }
    }

    public Double getDouble(String key) {
        return this.getValue(Double.class, key);
    }

    public Float getFloat(String key) {
        return this.getValue(Float.class, key);
    }

    public Long getLong(String key) {
        return this.getValue(Long.class, key);
    }

    public Short getShort(String key) {
        return this.getValue(Short.class, key);
    }

    public Byte[] getByteArray(String key) {
        return this.getValue(Byte[].class, key);
    }

    public Filter[] getFilterArray(String key) {
        return this.getValue(Filter[].class, key);
    }

    public <K, V> Pair<K, V> getPair(String key, Class<K> keyClass, Class<V> valueClass) {
        return this.getValue(Pair.class, key);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("ExtractorConfig{");
        sb.append("values=").append(this.values);
        sb.append(", extractorImplClass=").append(this.extractorImplClass);
        sb.append(", extractorImplClassName='").append(this.extractorImplClassName).append('\'');
        sb.append(", entityClass=").append(this.entityClass);
        sb.append('}');
        return sb.toString();
    }

    public <W> W getValue(Class<W> clazz, String key) {
        if (this.values.get(key) == null) {
            return null;
        }
        try {
            return (W)this.values.get(key);
        }
        catch (ClassCastException e) {
            if (Number.class.isAssignableFrom(clazz)) {
                try {
                    return (W)Utils.castNumberType(this.values.get(key), clazz.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e1) {
                    return null;
                }
            }
            throw e;
        }
    }

    public ExtractorConfig<T> clone() {
        ExtractorConfig<T> clonedObject = new ExtractorConfig<T>();
        clonedObject.getValues().putAll(this.getValues());
        clonedObject.setExtractorImplClass(this.getExtractorImplClass());
        clonedObject.setExtractorImplClassName(this.getExtractorImplClassName());
        clonedObject.setEntityClass(this.getEntityClass());
        return clonedObject;
    }
}

