/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.entity;

import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.exception.DeepGenericException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Cells
implements Iterable<Cell>,
Serializable {
    private static final long serialVersionUID = 3074521612130550380L;
    private final String nameSpace;
    private static final String DEFAULT_TABLE_NAME = "3fa2fbc6d8abbc77cdab9e3216d957dffd64a64b";
    private final Map<String, List<Cell>> cells = new HashMap<String, List<Cell>>();

    private List<Cell> getCellsByTable(String nameSpace) {
        String tName = StringUtils.isEmpty((String)nameSpace) ? this.nameSpace : nameSpace;
        List<Cell> res = this.cells.get(tName);
        if (res == null) {
            res = new ArrayList<Cell>();
            this.cells.put(tName, res);
        }
        return res;
    }

    public Cells() {
        this.nameSpace = DEFAULT_TABLE_NAME;
    }

    public Cells(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public Cells(Cell ... cells) {
        this(DEFAULT_TABLE_NAME, cells);
    }

    public Cells(String nameSpace, Cell ... cells) {
        this.nameSpace = nameSpace;
        if (StringUtils.isEmpty((String)nameSpace)) {
            throw new IllegalArgumentException("table name cannot be null");
        }
        Collections.addAll(this.getCellsByTable(nameSpace), cells);
    }

    public boolean add(Cell c) {
        if (c == null) {
            throw new DeepGenericException(new IllegalArgumentException("cell parameter cannot be null"));
        }
        return this.getCellsByTable(this.nameSpace).add(c);
    }

    public boolean add(String table, Cell c) {
        if (StringUtils.isEmpty((String)table)) {
            throw new IllegalArgumentException("table name cannot be null");
        }
        if (c == null) {
            throw new DeepGenericException(new IllegalArgumentException("cell parameter cannot be null"));
        }
        return this.getCellsByTable(table).add(c);
    }

    public void addAll(Map<String, List<Cell>> cells) {
        this.cells.putAll(cells);
    }

    public boolean replaceByName(String table, Cell c) {
        if (c == null) {
            throw new DeepGenericException(new IllegalArgumentException("cell parameter cannot be null"));
        }
        boolean cellFound = false;
        int position = 0;
        List<Cell> localCells = this.getCellsByTable(table);
        Iterator<Cell> cellsIt = localCells.iterator();
        while (!cellFound && cellsIt.hasNext()) {
            Cell currentCell = cellsIt.next();
            if (currentCell.getCellName().equals(c.getCellName())) {
                cellFound = true;
                continue;
            }
            ++position;
        }
        if (cellFound) {
            localCells.remove(position);
            return localCells.add(c);
        }
        return false;
    }

    public boolean replaceByName(Cell c) {
        return this.replaceByName(this.nameSpace, c);
    }

    public boolean remove(String table, String cellName) {
        if (cellName == null) {
            throw new DeepGenericException(new IllegalArgumentException("cell name parameter cannot be null"));
        }
        List<Cell> localCells = this.getCellsByTable(table);
        for (Cell currentCell : localCells) {
            if (!currentCell.getCellName().equals(cellName)) continue;
            return localCells.remove(currentCell);
        }
        return false;
    }

    public boolean remove(String cellName) {
        return this.remove(this.nameSpace, cellName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cells)) {
            return false;
        }
        Cells o = (Cells)obj;
        if (this.size() != o.size()) {
            return false;
        }
        for (Map.Entry<String, List<Cell>> entry : this.cells.entrySet()) {
            List<Cell> localCells = entry.getValue();
            for (Cell cell : localCells) {
                Cell otherCell = o.getCellByName(entry.getKey(), cell.getCellName());
                if (otherCell != null && otherCell.equals(cell)) continue;
                return false;
            }
        }
        return true;
    }

    public Cell getCellByIdx(int idx) {
        return this.getCellsByTable(this.nameSpace).get(idx);
    }

    public Cell getCellByIdx(String table, int idx) {
        return this.getCellsByTable(table).get(idx);
    }

    public Cell getCellByName(String cellName) {
        Set<String> keys = this.cells.keySet();
        for (String key : keys) {
            List<Cell> cellList = this.cells.get(key);
            for (Cell c : cellList) {
                if (!c.getCellName().equals(cellName)) continue;
                return c;
            }
        }
        return null;
    }

    public Cell getCellByName(String table, String cellName) {
        for (Cell c : this.getCellsByTable(table)) {
            if (!c.getCellName().equals(cellName)) continue;
            return c;
        }
        return null;
    }

    public Collection<Cell> getCells() {
        ArrayList res = new ArrayList();
        for (Map.Entry<String, List<Cell>> entry : this.cells.entrySet()) {
            res.addAll(entry.getValue());
        }
        return Collections.unmodifiableList(res);
    }

    public Collection<Cell> getCells(String nameSpace) {
        return Collections.unmodifiableList(this.getCellsByTable(nameSpace));
    }

    public Map<String, List<Cell>> getInternalCells() {
        return Collections.unmodifiableMap(this.cells);
    }

    public Collection<Object> getCellValues(String table) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Cell c : this.getCellsByTable(table)) {
            res.add(c.getCellValue());
        }
        return res;
    }

    public Collection<Object> getCellValues() {
        return this.getCellValues(this.nameSpace);
    }

    public Cells getIndexCells(String table) {
        Cells res = new Cells(table);
        for (Cell cell : this.getCellsByTable(table)) {
            if (!cell.isKey().booleanValue()) continue;
            res.add(table, cell);
        }
        return res;
    }

    public Cells getIndexCells() {
        Cells res = new Cells(this.nameSpace);
        for (Map.Entry<String, List<Cell>> entry : this.cells.entrySet()) {
            Cells keys = this.getIndexCells(entry.getKey());
            for (Cell c : keys) {
                res.add(entry.getKey(), c);
            }
        }
        return res;
    }

    public Cells getValueCells(String table) {
        Cells res = new Cells(table);
        for (Cell cell : this.getCellsByTable(table)) {
            if (cell.isKey().booleanValue()) continue;
            res.add(table, cell);
        }
        return res;
    }

    public Cells getValueCells() {
        Cells res = new Cells(this.nameSpace);
        for (Map.Entry<String, List<Cell>> entry : this.cells.entrySet()) {
            Cells keys = this.getValueCells(entry.getKey());
            for (Cell c : keys) {
                res.add(entry.getKey(), c);
            }
        }
        return res;
    }

    public int hashCode() {
        return this.cells.hashCode();
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.getCells().iterator();
    }

    public int size() {
        int acc = 0;
        for (Map.Entry<String, List<Cell>> entry : this.cells.entrySet()) {
            acc += entry.getValue().size();
        }
        return acc;
    }

    public int size(String table) {
        return this.getCellsByTable(table).size();
    }

    public boolean isEmpty() {
        if (this.cells.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, List<Cell>> entry : this.cells.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Cells{cells=" + this.cells + '}';
    }

    public String getnameSpace() {
        return this.nameSpace;
    }

    public <T> T getValue(String nameSpace, int idx, Class<T> cellClass) {
        Cell cell = this.getCellByIdx(nameSpace, idx);
        return cell == null ? null : (T)cell.getValue(cellClass);
    }

    public <T> T getValue(int idx, Class<T> cellClass) {
        Cell cell = this.getCellByIdx(idx);
        return cell == null ? null : (T)cell.getValue(cellClass);
    }

    public <T> T getValue(String nameSpace, String cellName, Class<T> cellClass) {
        Cell cell = this.getCellByName(nameSpace, cellName);
        return cell == null ? null : (T)cell.getValue(cellClass);
    }

    public <T> T getValue(String cellName, Class<T> cellClass) {
        Cell cell = this.getCellByName(cellName);
        return cell == null ? null : (T)cell.getValue(cellClass);
    }

    public <T> List<T> getList(String nameSpace, int idx, Class<T> elementsClass) {
        Cell cell = this.getCellByIdx(nameSpace, idx);
        return cell == null ? null : cell.getList(elementsClass);
    }

    public <T> List<T> getList(int idx, Class<T> elementsClass) {
        Cell cell = this.getCellByIdx(idx);
        return cell == null ? null : cell.getList(elementsClass);
    }

    public <T> List<T> getList(String nameSpace, String cellName, Class<T> elementsClass) {
        Cell cell = this.getCellByName(nameSpace, cellName);
        return cell == null ? null : cell.getList(elementsClass);
    }

    public <T> List<T> getList(String cellName, Class<T> elementsClass) {
        Cell cell = this.getCellByName(cellName);
        return cell == null ? null : cell.getList(elementsClass);
    }

    public <T> Set<T> getSet(String nameSpace, int idx, Class<T> elementsClass) {
        Cell cell = this.getCellByIdx(nameSpace, idx);
        return cell == null ? null : cell.getSet(elementsClass);
    }

    public <T> Set<T> getSet(int idx, Class<T> elementsClass) {
        Cell cell = this.getCellByIdx(idx);
        return cell == null ? null : cell.getSet(elementsClass);
    }

    public <T> Set<T> getSet(String nameSpace, String cellName, Class<T> elementsClass) {
        Cell cell = this.getCellByName(nameSpace, cellName);
        return cell == null ? null : cell.getSet(elementsClass);
    }

    public <T> Set<T> getSet(String cellName, Class<T> elementsClass) {
        Cell cell = this.getCellByName(cellName);
        return cell == null ? null : cell.getSet(elementsClass);
    }

    public <K, V> Map<K, V> getMap(String nameSpace, int idx, Class<K> keysClass, Class<V> valuesClass) {
        Cell cell = this.getCellByIdx(nameSpace, idx);
        return cell == null ? null : cell.getMap(keysClass, valuesClass);
    }

    public <K, V> Map<K, V> getMap(int idx, Class<K> keysClass, Class<V> valuesClass) {
        Cell cell = this.getCellByIdx(idx);
        return cell == null ? null : cell.getMap(keysClass, valuesClass);
    }

    public <K, V> Map<K, V> getMap(String nameSpace, String cellName, Class<K> keysClass, Class<V> valuesClass) {
        Cell cell = this.getCellByName(nameSpace, cellName);
        return cell == null ? null : cell.getMap(keysClass, valuesClass);
    }

    public <K, V> Map<K, V> getMap(String cellName, Class<K> keysClass, Class<V> valuesClass) {
        Cell cell = this.getCellByName(cellName);
        return cell == null ? null : cell.getMap(keysClass, valuesClass);
    }

    public String getString(String nameSpace, int idx) {
        return this.getValue(nameSpace, String.class);
    }

    public String getString(int idx) {
        return this.getValue(idx, String.class);
    }

    public String getString(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, String.class);
    }

    public String getString(String cellName) {
        return this.getValue(cellName, String.class);
    }

    public Character getCharacter(String nameSpace, int idx) {
        return this.getValue(nameSpace, Character.class);
    }

    public Character getCharacter(int idx) {
        return this.getValue(idx, Character.class);
    }

    public Character getCharacter(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Character.class);
    }

    public Character getCharacter(String cellName) {
        return this.getValue(cellName, Character.class);
    }

    public Byte getByte(String nameSpace, int idx) {
        return this.getValue(nameSpace, Byte.class);
    }

    public Byte getByte(int idx) {
        return this.getValue(idx, Byte.class);
    }

    public Byte getByte(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Byte.class);
    }

    public Byte getByte(String cellName) {
        return this.getValue(cellName, Byte.class);
    }

    public Date getDate(String nameSpace, int idx) {
        return this.getValue(nameSpace, Date.class);
    }

    public Date getDate(int idx) {
        return this.getValue(idx, Date.class);
    }

    public Date getDate(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Date.class);
    }

    public Date getDate(String cellName) {
        return this.getValue(cellName, Date.class);
    }

    public Boolean getBoolean(String nameSpace, int idx) {
        return this.getValue(nameSpace, Boolean.class);
    }

    public Boolean getBoolean(int idx) {
        return this.getValue(idx, Boolean.class);
    }

    public Boolean getBoolean(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Boolean.class);
    }

    public Boolean getBoolean(String cellName) {
        return this.getValue(cellName, Boolean.class);
    }

    public Short getShort(String nameSpace, int idx) {
        return this.getValue(nameSpace, Short.class);
    }

    public Short getShort(int idx) {
        return this.getValue(idx, Short.class);
    }

    public Short getShort(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Short.class);
    }

    public Short getShort(String cellName) {
        return this.getValue(cellName, Short.class);
    }

    public Integer getInteger(String nameSpace, int idx) {
        return this.getValue(nameSpace, Integer.class);
    }

    public Integer getInteger(int idx) {
        return this.getValue(idx, Integer.class);
    }

    public Integer getInteger(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Integer.class);
    }

    public Integer getInteger(String cellName) {
        return this.getValue(cellName, Integer.class);
    }

    public Float getFloat(String nameSpace, int idx) {
        return this.getValue(nameSpace, Float.class);
    }

    public Float getFloat(int idx) {
        return this.getValue(idx, Float.class);
    }

    public Float getFloat(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Float.class);
    }

    public Float getFloat(String cellName) {
        return this.getValue(cellName, Float.class);
    }

    public Long getLong(String nameSpace, int idx) {
        return this.getValue(nameSpace, Long.class);
    }

    public Long getLong(int idx) {
        return this.getValue(idx, Long.class);
    }

    public Long getLong(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Long.class);
    }

    public Long getLong(String cellName) {
        return this.getValue(cellName, Long.class);
    }

    public Double getDouble(String nameSpace, int idx) {
        return this.getValue(nameSpace, Double.class);
    }

    public Double getDouble(int idx) {
        return this.getValue(idx, Double.class);
    }

    public Double getDouble(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Double.class);
    }

    public Double getDouble(String cellName) {
        return this.getValue(cellName, Double.class);
    }

    public BigInteger getBigInteger(String nameSpace, int idx) {
        return this.getValue(nameSpace, BigInteger.class);
    }

    public BigInteger getBigInteger(int idx) {
        return this.getValue(idx, BigInteger.class);
    }

    public BigInteger getBigInteger(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, BigInteger.class);
    }

    public BigInteger getBigInteger(String cellName) {
        return this.getValue(cellName, BigInteger.class);
    }

    public BigDecimal getBigDecimal(String nameSpace, int idx) {
        return this.getValue(nameSpace, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(int idx) {
        return this.getValue(idx, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(String cellName) {
        return this.getValue(cellName, BigDecimal.class);
    }

    public ByteBuffer getByteBuffer(String nameSpace, int idx) {
        return this.getValue(nameSpace, ByteBuffer.class);
    }

    public ByteBuffer getByteBuffer(int idx) {
        return this.getValue(idx, ByteBuffer.class);
    }

    public ByteBuffer getByteBuffer(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, ByteBuffer.class);
    }

    public ByteBuffer getByteBuffer(String cellName) {
        return this.getValue(cellName, ByteBuffer.class);
    }

    public URL getURL(String nameSpace, int idx) {
        return this.getValue(nameSpace, URL.class);
    }

    public URL getURL(int idx) {
        return this.getValue(idx, URL.class);
    }

    public URL getURL(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, URL.class);
    }

    public URL getURL(String cellName) {
        return this.getValue(cellName, URL.class);
    }

    public InetAddress getInetAddress(String nameSpace, int idx) {
        return this.getValue(nameSpace, InetAddress.class);
    }

    public InetAddress getInetAddress(int idx) {
        return this.getValue(idx, InetAddress.class);
    }

    public InetAddress getInetAddress(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, InetAddress.class);
    }

    public InetAddress getInetAddress(String cellName) {
        return this.getValue(cellName, InetAddress.class);
    }

    public Byte[] getBytes(String nameSpace, int idx) {
        return this.getValue(nameSpace, Byte[].class);
    }

    public Byte[] getBytes(int idx) {
        return this.getValue(idx, Byte[].class);
    }

    public Byte[] getBytes(String nameSpace, String cellName) {
        return this.getValue(nameSpace, cellName, Byte[].class);
    }

    public Byte[] getBytes(String cellName) {
        return this.getValue(cellName, Byte[].class);
    }
}

