/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.extractor.server;

import com.stratio.deep.commons.extractor.server.ExtractorServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.SSLException;

public final class ExtractorServer {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final int PORT = Integer.parseInt(System.getProperty("port", "8463"));
    private static EventLoopGroup workerGroup;
    private static EventLoopGroup bossGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            ExtractorServer.start();
        }
        finally {
            ExtractorServer.close();
        }
    }

    public static void start() throws CertificateException, SSLException, InterruptedException {
        SslContext sslCtx;
        if (SSL) {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            sslCtx = SslContext.newServerContext((File)ssc.certificate(), (File)ssc.privateKey());
        } else {
            sslCtx = null;
        }
        bossGroup = new NioEventLoopGroup(1);
        workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler(new ExtractorServerInitializer(sslCtx));
        b.bind(PORT).sync().channel().closeFuture().sync();
    }

    public static void close() {
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
    }

    public static void initExtractorServer() {
        ExecutorService es = Executors.newFixedThreadPool(1);
        Future future = es.submit(new Callable(){

            public Object call() throws Exception {
                ExtractorServer.start();
                return null;
            }
        });
    }

    public static void stopExtractorServer() {
        ExtractorServer.close();
    }
}

