/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.utils;

import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.utils.AnnotationUtils;
import com.stratio.deep.commons.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.api.java.DataType;
import org.apache.spark.sql.api.java.Row;
import org.apache.spark.sql.api.java.StringType;
import org.apache.spark.sql.api.java.StructField;
import org.apache.spark.sql.api.java.StructType;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CellsUtils.class);

    public static JSONObject getJsonFromCell(Cells cells) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        JSONObject json = new JSONObject();
        for (Cell cell : cells) {
            if (cell.getCellValue() == null) continue;
            if (Collection.class.isAssignableFrom(cell.getCellValue().getClass())) {
                Collection c = (Collection)cell.getCellValue();
                Iterator iterator = c.iterator();
                ArrayList<JSONObject> innerJsonList = new ArrayList<JSONObject>();
                while (iterator.hasNext()) {
                    innerJsonList.add(CellsUtils.getJsonFromCell((Cells)iterator.next()));
                }
                json.put((Object)cell.getCellName(), innerJsonList);
                continue;
            }
            if (Cells.class.isAssignableFrom(cell.getCellValue().getClass())) {
                json.put((Object)cell.getCellName(), (Object)CellsUtils.getJsonFromCell((Cells)cell.getCellValue()));
                continue;
            }
            json.put((Object)cell.getCellName(), cell.getCellValue());
        }
        return json;
    }

    public static Cells getCellFromJson(JSONObject Json, String tableName) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Cells cells = tableName != null ? new Cells(tableName) : new Cells();
        Set entrySet = Json.keySet();
        for (String key : entrySet) {
            try {
                Object value = Json.get((Object)key);
                if (List.class.isAssignableFrom(value.getClass())) {
                    ArrayList<Cells> innerCell = new ArrayList<Cells>();
                    for (JSONObject innerBson : (List)value) {
                        innerCell.add(CellsUtils.getCellFromJson(innerBson, null));
                    }
                    cells.add(Cell.create(key, innerCell));
                    continue;
                }
                if (JSONObject.class.isAssignableFrom(value.getClass())) {
                    Cells innerCells = CellsUtils.getCellFromJson((JSONObject)value, null);
                    cells.add(Cell.create(key, innerCells));
                    continue;
                }
                if (key.equalsIgnoreCase("id")) {
                    cells.add(Cell.create(key, value, true));
                    continue;
                }
                cells.add(Cell.create(key, value));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LOG.error("impossible to create a java cell from Json field:" + key);
            }
        }
        return cells;
    }

    public static Cells getCellWithMapFromJson(JSONObject Json, String tableName) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Cells cells = tableName != null ? new Cells(tableName) : new Cells();
        Set entrySet = Json.keySet();
        for (String key : entrySet) {
            try {
                Object value = Json.get((Object)key);
                if (List.class.isAssignableFrom(value.getClass())) {
                    ArrayList<String> innerCell = new ArrayList<String>();
                    for (String innerBson : (List)value) {
                        innerCell.add(innerBson);
                    }
                    cells.add(Cell.create(key, innerCell));
                    continue;
                }
                if (JSONObject.class.isAssignableFrom(value.getClass())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Cells innerCells = CellsUtils.getCellFromJson((JSONObject)value, null);
                    for (Cell cell : innerCells) {
                        map.put(cell.getName(), cell.getValue());
                    }
                    cells.add(Cell.create(key, map));
                    continue;
                }
                if (key.equalsIgnoreCase("id")) {
                    cells.add(Cell.create(key, value, true));
                    continue;
                }
                cells.add(Cell.create(key, value));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LOG.error("impossible to create a java cell from Bson field:" + key);
            }
        }
        return cells;
    }

    public static <T> T getObjectFromJson(Class<T> classEntity, JSONObject bsonObject) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        T t = classEntity.newInstance();
        Field[] fields = AnnotationUtils.filterDeepFields(classEntity);
        Object insert = null;
        for (Field field : fields) {
            Object currentBson = null;
            Method method = null;
            try {
                method = Utils.findSetter(field.getName(), classEntity, field.getType());
                Class<?> classField = field.getType();
                currentBson = bsonObject.get((Object)AnnotationUtils.deepFieldName(field));
                if (currentBson == null) continue;
                if (Iterable.class.isAssignableFrom(classField)) {
                    Type type = field.getGenericType();
                    insert = CellsUtils.subDocumentListCase(type, (List)bsonObject.get((Object)AnnotationUtils.deepFieldName(field)));
                } else {
                    insert = IDeepType.class.isAssignableFrom(classField) ? CellsUtils.getObjectFromJson(classField, (JSONObject)bsonObject.get((Object)AnnotationUtils.deepFieldName(field))) : currentBson;
                }
                method.invoke(t, insert);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LOG.error("impossible to create a java object from Bson field:" + field.getName() + " and type:" + field.getType() + " and value:" + t + "; bsonReceived:" + currentBson + ", bsonClassReceived:" + currentBson.getClass());
                method.invoke(t, Utils.castNumberType(insert, t));
            }
        }
        return t;
    }

    public static <T> T getObjectWithMapFromJson(Class<T> classEntity, JSONObject bsonObject) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        T t = classEntity.newInstance();
        Field[] fields = AnnotationUtils.filterDeepFields(classEntity);
        Object insert = null;
        for (Field field : fields) {
            Object currentBson = null;
            Method method = null;
            try {
                method = Utils.findSetter(field.getName(), classEntity, field.getType());
                Class<?> classField = field.getType();
                currentBson = bsonObject.get((Object)AnnotationUtils.deepFieldName(field));
                if (currentBson == null) continue;
                if (Collection.class.isAssignableFrom(classField)) {
                    Type type = field.getGenericType();
                    ArrayList<String> list = new ArrayList<String>();
                    for (Object o : (List)bsonObject.get((Object)AnnotationUtils.deepFieldName(field))) {
                        list.add((String)o);
                    }
                    insert = list;
                } else {
                    insert = IDeepType.class.isAssignableFrom(classField) ? CellsUtils.getObjectFromJson(classField, (JSONObject)bsonObject.get((Object)AnnotationUtils.deepFieldName(field))) : currentBson;
                }
                if (insert == null) continue;
                method.invoke(t, insert);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                LOG.error("impossible to create a java object from Bson field:" + field.getName() + " and type:" + field.getType() + " and value:" + t + "; bsonReceived:" + currentBson + ", bsonClassReceived:" + currentBson.getClass());
                method.invoke(t, Utils.castNumberType(insert, t));
            }
        }
        return t;
    }

    public static Row getRowFromCells(Cells cells) {
        Object[] values = cells.getCellValues().toArray();
        return Row.create((Object[])values);
    }

    public static Collection<Row> getRowsFromsCells(Collection<Cells> cellsCol) {
        ArrayList<Row> result = new ArrayList<Row>();
        for (Cells cells : cellsCol) {
            result.add(CellsUtils.getRowFromCells(cells));
        }
        return result;
    }

    public static StructType getStructTypeFromCells(Cells cells) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (Cell cell : cells.getCells()) {
            StructField field = CellsUtils.getStructFieldFromCell(cell);
            fields.add(field);
        }
        return StructType.createStructType(fields);
    }

    private static StructField getStructFieldFromCell(Cell cell) {
        StructField field = DataType.createStructField((String)cell.getName(), (DataType)CellsUtils.getDataType(cell.getValue()), (boolean)false);
        return field;
    }

    private static DataType getDataType(Object value) {
        StringType dataType;
        Class<?> cls = value.getClass();
        if (cls.equals(String.class)) {
            dataType = DataType.StringType;
        } else if (cls.equals(Byte[].class)) {
            dataType = DataType.BinaryType;
        } else if (cls.equals(Boolean.class)) {
            dataType = DataType.BooleanType;
        } else if (cls.equals(Timestamp.class)) {
            dataType = DataType.TimestampType;
        } else if (cls.equals(BigDecimal.class)) {
            dataType = DataType.DecimalType;
        } else if (cls.equals(Double.class)) {
            dataType = DataType.DoubleType;
        } else if (cls.equals(Float.class)) {
            dataType = DataType.FloatType;
        } else if (cls.equals(Byte.class)) {
            dataType = DataType.ByteType;
        } else if (cls.equals(Integer.class)) {
            dataType = DataType.IntegerType;
        } else if (cls.equals(Long.class)) {
            dataType = DataType.LongType;
        } else if (cls.equals(Short.class)) {
            dataType = DataType.ShortType;
        } else if (value instanceof List) {
            List listValue = (List)value;
            dataType = listValue.isEmpty() ? DataType.createArrayType((DataType)DataType.StringType) : DataType.createArrayType((DataType)CellsUtils.getDataType(listValue.get(0)));
        } else if (value instanceof Map) {
            Map mapValue = (Map)value;
            if (mapValue.isEmpty()) {
                dataType = DataType.createMapType((DataType)DataType.StringType, (DataType)DataType.StringType);
            } else {
                Map.Entry entry = mapValue.entrySet().iterator().next();
                dataType = DataType.createMapType((DataType)CellsUtils.getDataType(entry.getKey()), (DataType)CellsUtils.getDataType(entry.getValue()));
            }
        } else {
            dataType = DataType.StringType;
        }
        return dataType;
    }

    private static <T> Object subDocumentListCase(Type type, List<T> jsonObject) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ParameterizedType listType = (ParameterizedType)type;
        Class listClass = (Class)listType.getActualTypeArguments()[0];
        ArrayList<T> list = new ArrayList<T>();
        for (T t : jsonObject) {
            list.add(CellsUtils.getObjectFromJson(listClass, (JSONObject)t));
        }
        return list;
    }
}

