/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.utils;

import com.stratio.deep.commons.exception.DeepInstantiationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.log4j.Logger;

public class DeepSparkHadoopMapReduceUtil {
    private static final Logger LOG = Logger.getLogger(DeepSparkHadoopMapReduceUtil.class);

    public static JobContext newJobContext(Configuration conf, JobID jobId) {
        try {
            Class clazz = DeepSparkHadoopMapReduceUtil.firstAvailableClass("org.apache.hadoop.mapreduce.task.JobContextImpl", "org.apache.hadoop.mapreduce.JobContext");
            Constructor constructor = clazz.getDeclaredConstructor(Configuration.class, JobID.class);
            return (JobContext)constructor.newInstance(conf, jobId);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error((Object)("to use hadoop classes, we need them in the classpath " + e.getMessage()));
            throw new DeepInstantiationException("to use hadoop classes, we need them in the classpath  " + e.getMessage());
        }
    }

    public static TaskAttemptContext newTaskAttemptContext(Configuration conf, TaskAttemptID attemptId) {
        try {
            Class clazz = DeepSparkHadoopMapReduceUtil.firstAvailableClass("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl", "org.apache.hadoop.mapreduce.TaskAttemptContext");
            Constructor constructor = clazz.getDeclaredConstructor(Configuration.class, TaskAttemptID.class);
            return (TaskAttemptContext)constructor.newInstance(conf, attemptId);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error((Object)("to use hadoop classes, we need them in the classpath " + e.getMessage()));
            throw new DeepInstantiationException("to use hadoop classes, we need them in the classpath  " + e.getMessage());
        }
    }

    public static TaskAttemptID newTaskAttemptID(String jtIdentifier, int jobId, boolean isMap, int taskId, int attemptId) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.apache.hadoop.mapreduce.TaskAttemptID");
            Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE);
            return (TaskAttemptID)constructor.newInstance(jtIdentifier, jobId, isMap, taskId, attemptId);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            try {
                TaskType type = null;
                type = isMap ? TaskType.MAP : TaskType.REDUCE;
                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, Integer.TYPE, TaskType.class, Integer.TYPE, Integer.TYPE);
                return (TaskAttemptID)constructor.newInstance(jtIdentifier, jobId, type, taskId, attemptId);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
                LOG.error((Object)("to use hadoop classes, we need them in the classpath " + e.getMessage()));
                throw new DeepInstantiationException("to use hadoop classes, we need them in the classpath  " + e1.getMessage());
            }
        }
    }

    private static Class firstAvailableClass(String first, String second) {
        try {
            return Class.forName(first);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(second);
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }
}

