/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.commons.utils;

import com.stratio.deep.commons.config.BaseConfig;
import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.exception.DeepExtractorInitializationException;
import com.stratio.deep.commons.exception.DeepGenericException;
import com.stratio.deep.commons.exception.DeepIOException;
import com.stratio.deep.commons.rdd.IExtractor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import scala.Tuple2;

public final class Utils {
    public static <T extends IDeepType> T newTypeInstance(Class<T> clazz) {
        try {
            return (T)((IDeepType)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DeepGenericException(e);
        }
    }

    public static <T> T newTypeInstance(String className, Class<T> returnClass) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new DeepGenericException(e);
        }
    }

    public static String quote(String identifier) {
        if (StringUtils.isEmpty((String)identifier)) {
            return identifier;
        }
        String res = identifier.trim();
        if (!res.startsWith("\"")) {
            res = "\"" + res;
        }
        if (!res.endsWith("\"")) {
            res = res + "\"";
        }
        return res;
    }

    public static String singleQuote(String identifier) {
        if (StringUtils.isEmpty((String)identifier)) {
            return identifier;
        }
        String res = identifier.trim();
        if (!res.startsWith("'")) {
            res = "'" + res;
        }
        if (!res.endsWith("'")) {
            res = res + "'";
        }
        return res;
    }

    public static String batchQueryGenerator(List<String> statements) {
        StringBuilder sb = new StringBuilder("BEGIN BATCH \n");
        for (String statement : statements) {
            sb.append(statement).append("\n");
        }
        sb.append(" APPLY BATCH;");
        return sb.toString();
    }

    public static Tuple2<String[], Object[]> prepareTuple4CqlDriver(Tuple2<Cells, Cells> tuple) {
        Cell cell;
        Cells keys = (Cells)tuple._1();
        Cells columns = (Cells)tuple._2();
        String[] names = new String[keys.size() + columns.size()];
        Object[] values = new Object[keys.size() + columns.size()];
        for (int k = 0; k < keys.size(); ++k) {
            cell = keys.getCellByIdx(k);
            names[k] = Utils.quote(cell.getCellName());
            values[k] = cell.getCellValue();
        }
        for (int v = keys.size(); v < keys.size() + columns.size(); ++v) {
            cell = columns.getCellByIdx(v - keys.size());
            names[v] = Utils.quote(cell.getCellName());
            values[v] = cell.getCellValue();
        }
        return new Tuple2((Object)names, (Object)values);
    }

    public static Method findSetter(String propertyName, Class entityClass, Class valueType) {
        Method setter;
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            setter = entityClass.getMethod(setterName, valueType);
        }
        catch (NoSuchMethodException e) {
            try {
                setter = entityClass.getMethod(propertyName + "_$eq", valueType);
            }
            catch (NoSuchMethodException e1) {
                throw new DeepIOException(e1);
            }
        }
        return setter;
    }

    public static boolean setFieldWithReflection(Object object, String fieldName, Object fieldValue) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(object, fieldValue);
                return true;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return false;
    }

    public static Method findGetter(String propertyName, Class entityClass) {
        Method getter;
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            getter = entityClass.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                getter = entityClass.getMethod(propertyName + "_$eq", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new DeepIOException(e1);
            }
        }
        return getter;
    }

    public static InetAddress inetAddressFromLocation(String location) {
        try {
            return InetAddress.getByName(location);
        }
        catch (UnknownHostException e) {
            throw new DeepIOException(e);
        }
    }

    public static Field[] getAllFields(Class clazz) {
        return Utils.getAllFieldsRec(clazz, new ArrayList<Field>());
    }

    private static Field[] getAllFieldsRec(Class clazz, List<Field> fields) {
        Class superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            Utils.getAllFieldsRec(superClazz, fields);
        }
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return fields.toArray(new Field[fields.size()]);
    }

    private Utils() {
    }

    public static List<String> removeAddressPort(List<String> stringList) {
        ArrayList<String> adresNoPort = new ArrayList<String>();
        for (String s : stringList) {
            int index = s.indexOf(":");
            if (index > -1) {
                adresNoPort.add(s.substring(0, index));
                continue;
            }
            adresNoPort.add(s);
        }
        return adresNoPort;
    }

    public static String splitListByComma(List<String> hosts) {
        boolean firstHost = true;
        StringBuilder hostConnection = new StringBuilder();
        for (String host : hosts) {
            if (!firstHost) {
                hostConnection.append(",");
            }
            hostConnection.append(host.trim());
            firstHost = false;
        }
        return hostConnection.toString();
    }

    public static <T, S extends BaseConfig<T>> IExtractor<T, S> getExtractorInstance(S config) {
        try {
            Class<?> rdd = config.getExtractorImplClass();
            if (rdd == null) {
                rdd = Class.forName(config.getExtractorImplClassName());
            }
            if (config.getEntityClass().isAssignableFrom(Cells.class)) {
                Constructor<?> c = rdd.getConstructor(new Class[0]);
                return (IExtractor)c.newInstance(new Object[0]);
            }
            Constructor<?> c = rdd.getConstructor(Class.class);
            return (IExtractor)c.newInstance(config.getEntityClass());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new DeepExtractorInitializationException(e.getMessage());
        }
    }

    public static Object castNumberType(Object object, Object clazz) {
        if (object instanceof Number) {
            if (clazz instanceof Double) {
                return ((Number)object).doubleValue();
            }
            if (clazz instanceof Long) {
                return ((Number)object).longValue();
            }
            if (clazz instanceof Float) {
                return Float.valueOf(((Number)object).floatValue());
            }
            if (clazz instanceof Integer) {
                return ((Number)object).intValue();
            }
            if (clazz instanceof Short) {
                return ((Number)object).shortValue();
            }
            if (clazz instanceof Byte) {
                return ((Number)object).byteValue();
            }
        }
        throw new ClassCastException("it is not a Number Type");
    }

    public static Object castingUtil(String value, Class classCasting) {
        String object = value;
        if (Number.class.isAssignableFrom(classCasting)) {
            if (classCasting.isAssignableFrom(Double.class)) {
                return Double.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Long.class)) {
                return Long.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Float.class)) {
                return Float.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Integer.class)) {
                return Integer.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Short.class)) {
                return Short.valueOf(value);
            }
            if (classCasting.isAssignableFrom(Byte.class)) {
                return Byte.valueOf(value);
            }
        } else {
            if (String.class.isAssignableFrom(classCasting)) {
                return object.toString();
            }
            return null;
        }
        return null;
    }
}

