/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.es.config;

import com.stratio.deep.commons.config.ExtractorConfig;
import com.stratio.deep.commons.config.HadoopConfig;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.filter.Filter;
import com.stratio.deep.commons.utils.Utils;
import com.stratio.deep.es.config.IESDeepJobConfig;
import com.stratio.deep.es.extractor.ESCellExtractor;
import com.stratio.deep.es.extractor.ESEntityExtractor;
import com.stratio.deep.es.utils.UtilES;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.elasticsearch.hadoop.mr.EsInputFormat;
import org.elasticsearch.hadoop.mr.EsOutputFormat;

public class ESDeepJobConfig<T>
extends HadoopConfig<T, ESDeepJobConfig<T>>
implements IESDeepJobConfig<T> {
    private static final long serialVersionUID = -7179376653643603038L;
    private String query;
    private Map<String, Serializable> customConfiguration;

    public ESDeepJobConfig(Class<T> entityClass) {
        super(entityClass);
        this.extractorImplClass = Cells.class.isAssignableFrom(entityClass) ? ESCellExtractor.class : ESEntityExtractor.class;
    }

    public String getResource() {
        return this.table != null ? this.catalog.concat("/").concat(this.table) : this.catalog;
    }

    public ESDeepJobConfig<T> initialize() {
        this.validate();
        this.configHadoop = new JobConf();
        ((JobConf)this.configHadoop).setInputFormat(EsInputFormat.class);
        ((JobConf)this.configHadoop).setOutputFormat(EsOutputFormat.class);
        this.configHadoop.set("es.resource", this.getResource());
        this.configHadoop.set("es.field.read.empty.as.null", "false");
        if (this.query != null) {
            this.configHadoop.set("es.query", this.query);
        }
        if (this.inputColumns != null && this.inputColumns.length > 0) {
            this.configHadoop.set("es.scroll.fields", Utils.splitListByComma(Arrays.asList(this.inputColumns)));
        }
        this.configHadoop.set("es.nodes", Utils.splitListByComma((List)this.host));
        this.configHadoop.set("es.port", String.valueOf(this.port));
        this.configHadoop.set("es.input.json", "yes");
        if (this.customConfiguration != null) {
            Set<Map.Entry<String, Serializable>> set = this.customConfiguration.entrySet();
            for (Map.Entry<String, Serializable> entry : set) {
                this.configHadoop.set(entry.getKey(), entry.getValue().toString());
            }
        }
        return this;
    }

    private void validate() {
        if (this.host.isEmpty()) {
            throw new IllegalArgumentException("host cannot be null");
        }
        if (this.catalog == null) {
            throw new IllegalArgumentException("index cannot be null");
        }
    }

    @Override
    public Configuration getHadoopConfiguration() {
        if (this.configHadoop == null) {
            this.initialize();
        }
        return this.configHadoop;
    }

    @Override
    public ESDeepJobConfig<T> filterQuery(String query) {
        this.query = query;
        return this;
    }

    @Override
    public ESDeepJobConfig<T> sort(String sort) {
        return null;
    }

    @Override
    public ESDeepJobConfig<T> type(String type) {
        this.table = type;
        return this;
    }

    public ESDeepJobConfig<T> tipe(String type) {
        this.table = type;
        return this;
    }

    @Override
    public ESDeepJobConfig<T> index(String index) {
        this.catalog = index;
        return this;
    }

    @Override
    public String getType() {
        return this.table;
    }

    @Override
    public String getIndex() {
        return this.catalog;
    }

    public String getNameSpace() {
        if (this.nameSpace == null) {
            this.nameSpace = this.getIndex() + "." + this.getType();
        }
        return this.nameSpace;
    }

    @Override
    public ESDeepJobConfig<T> customConfiguration(Map<String, Serializable> customConfiguration) {
        this.customConfiguration = customConfiguration;
        return this;
    }

    @Override
    public Map<String, Serializable> getCustomConfiguration() {
        return this.customConfiguration;
    }

    public ESDeepJobConfig<T> initialize(ExtractorConfig extractorConfig) {
        super.initialize(extractorConfig);
        Map values = extractorConfig.getValues();
        if (values.get("inputColumns") != null) {
            this.inputColumns(extractorConfig.getStringArray("inputColumns"));
        }
        if (values.get("filterQuery") != null) {
            this.filterQuery(extractorConfig.getFilterArray("filterQuery"));
        }
        this.initialize();
        return this;
    }

    private ESDeepJobConfig<T> filterQuery(Filter[] filterArray) {
        this.query = "{ \"query\" :".concat(UtilES.generateQuery(filterArray).toString()).concat("}");
        return this;
    }
}

