/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.es.extractor;

import com.stratio.deep.commons.config.DeepJobConfig;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.exception.DeepTransformException;
import com.stratio.deep.commons.extractor.impl.GenericHadoopExtractor;
import com.stratio.deep.es.config.ESDeepJobConfig;
import com.stratio.deep.es.utils.UtilES;
import java.lang.reflect.InvocationTargetException;
import org.elasticsearch.hadoop.mr.EsInputFormat;
import org.elasticsearch.hadoop.mr.EsOutputFormat;
import org.elasticsearch.hadoop.mr.LinkedMapWritable;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class ESCellExtractor
extends GenericHadoopExtractor<Cells, ESDeepJobConfig<Cells>, Object, LinkedMapWritable, Object, JSONObject> {
    private static final Logger LOG = LoggerFactory.getLogger(ESCellExtractor.class);
    private static final long serialVersionUID = -3208994171892747470L;

    public ESCellExtractor() {
        this(Cells.class);
    }

    public ESCellExtractor(Class<Cells> cellsClass) {
        this.deepJobConfig = new ESDeepJobConfig<Cells>(cellsClass);
        this.inputFormat = new EsInputFormat();
        this.outputFormat = new EsOutputFormat();
    }

    public Cells transformElement(Tuple2<Object, LinkedMapWritable> tuple, DeepJobConfig<Cells, ? extends DeepJobConfig> config) {
        try {
            return UtilES.getCellFromJson((LinkedMapWritable)tuple._2(), this.deepJobConfig.getNameSpace());
        }
        catch (Exception e) {
            LOG.error("Cannot convert JSON: ", (Throwable)e);
            throw new DeepTransformException("Could not transform from Json to Cell " + e.getMessage());
        }
    }

    public Tuple2<Object, JSONObject> transformElement(Cells record) {
        try {
            return new Tuple2(null, (Object)UtilES.getJsonFromCell(record));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error(e.getMessage());
            throw new DeepTransformException(e.getMessage());
        }
    }
}

