/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.es.extractor;

import com.stratio.deep.commons.config.DeepJobConfig;
import com.stratio.deep.commons.exception.DeepTransformException;
import com.stratio.deep.commons.extractor.impl.GenericHadoopExtractor;
import com.stratio.deep.es.config.ESDeepJobConfig;
import com.stratio.deep.es.utils.UtilES;
import java.lang.reflect.InvocationTargetException;
import org.elasticsearch.hadoop.mr.EsInputFormat;
import org.elasticsearch.hadoop.mr.EsOutputFormat;
import org.elasticsearch.hadoop.mr.LinkedMapWritable;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class ESEntityExtractor<T>
extends GenericHadoopExtractor<T, ESDeepJobConfig<T>, Object, LinkedMapWritable, Object, JSONObject> {
    private static final Logger LOG = LoggerFactory.getLogger(ESEntityExtractor.class);
    private static final long serialVersionUID = -3208994171892747470L;

    public ESEntityExtractor(Class<T> t) {
        this.deepJobConfig = new ESDeepJobConfig<T>(t);
        this.inputFormat = new EsInputFormat();
        this.outputFormat = new EsOutputFormat();
    }

    public T transformElement(Tuple2<Object, LinkedMapWritable> tuple, DeepJobConfig<T, ? extends DeepJobConfig> config) {
        try {
            return UtilES.getObjectFromJson(config.getEntityClass(), (LinkedMapWritable)tuple._2());
        }
        catch (Exception e) {
            LOG.error("Cannot convert JSON: ", (Throwable)e);
            throw new DeepTransformException("Could not transform from Json to Entity " + e.getMessage());
        }
    }

    public Tuple2<Object, JSONObject> transformElement(T record) {
        try {
            return new Tuple2(null, (Object)UtilES.getJsonFromObject(record));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error(e.getMessage());
            throw new DeepTransformException(e.getMessage());
        }
    }
}

