/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.deep.es.utils;

import com.stratio.deep.commons.entity.Cell;
import com.stratio.deep.commons.entity.Cells;
import com.stratio.deep.commons.entity.IDeepType;
import com.stratio.deep.commons.filter.Filter;
import com.stratio.deep.commons.filter.FilterType;
import com.stratio.deep.commons.utils.AnnotationUtils;
import com.stratio.deep.commons.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.mr.LinkedMapWritable;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UtilES {
    private static final Logger LOG = LoggerFactory.getLogger(UtilES.class);

    private UtilES() {
        throw new UnsupportedOperationException();
    }

    public static <T> T getObjectFromJson(Class<T> classEntity, LinkedMapWritable jsonObject) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Field[] fields;
        T t = classEntity.newInstance();
        for (Field field : fields = AnnotationUtils.filterDeepFields(classEntity)) {
            Object insert;
            Method method = Utils.findSetter((String)field.getName(), classEntity, field.getType());
            Class<?> classField = field.getType();
            String key = AnnotationUtils.deepFieldName((Field)field);
            Text text = new Text(key);
            Writable currentJson = jsonObject.get((Object)text);
            if (currentJson == null) continue;
            if (Iterable.class.isAssignableFrom(classField)) {
                Type type = field.getGenericType();
                insert = UtilES.subDocumentListCase(type, (ArrayWritable)currentJson);
                method.invoke(t, insert);
                continue;
            }
            if (IDeepType.class.isAssignableFrom(classField)) {
                insert = UtilES.getObjectFromJson(classField, (LinkedMapWritable)currentJson);
                method.invoke(t, insert);
                continue;
            }
            insert = currentJson;
            try {
                method.invoke(t, UtilES.getObjectFromWritable(insert));
            }
            catch (Exception e) {
                LOG.error("impossible to convert field " + t + " :" + field + " error: " + e.getMessage());
                method.invoke(t, Utils.castNumberType((Object)UtilES.getObjectFromWritable(insert), t.getClass()));
            }
        }
        return t;
    }

    private static <T> Object subDocumentListCase(Type type, ArrayWritable arrayWritable) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        ParameterizedType listType = (ParameterizedType)type;
        Class listClass = (Class)listType.getActualTypeArguments()[0];
        ArrayList<T> list = new ArrayList<T>();
        Writable[] writetable = arrayWritable.get();
        for (int i = 0; i < writetable.length; ++i) {
            list.add(UtilES.getObjectFromJson(listClass, (LinkedMapWritable)writetable[i]));
        }
        return list;
    }

    public static <T> JSONObject getJsonFromObject(T t) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Field[] fields = AnnotationUtils.filterDeepFields(t.getClass());
        JSONObject json = new JSONObject();
        for (Field field : fields) {
            Method method = Utils.findGetter((String)field.getName(), t.getClass());
            Object object = method.invoke(t, new Object[0]);
            if (object == null) continue;
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection c = (Collection)object;
                Iterator iterator = c.iterator();
                ArrayList<JSONObject> innerJsonList = new ArrayList<JSONObject>();
                while (iterator.hasNext()) {
                    innerJsonList.add(UtilES.getJsonFromObject((IDeepType)iterator.next()));
                }
                json.put((Object)AnnotationUtils.deepFieldName((Field)field), innerJsonList);
                continue;
            }
            if (IDeepType.class.isAssignableFrom(field.getType())) {
                json.put((Object)AnnotationUtils.deepFieldName((Field)field), (Object)UtilES.getJsonFromObject((IDeepType)object));
                continue;
            }
            json.put((Object)AnnotationUtils.deepFieldName((Field)field), object);
        }
        return json;
    }

    public static <T> LinkedMapWritable getLinkedMapWritableFromObject(T t) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Field[] fields = AnnotationUtils.filterDeepFields(t.getClass());
        LinkedMapWritable linkedMapWritable = new LinkedMapWritable();
        for (Field field : fields) {
            Method method = Utils.findGetter((String)field.getName(), t.getClass());
            Object object = method.invoke(t, new Object[0]);
            if (object == null) continue;
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection c = (Collection)object;
                Iterator iterator = c.iterator();
                ArrayList<LinkedMapWritable> innerJsonList = new ArrayList<LinkedMapWritable>();
                while (iterator.hasNext()) {
                    innerJsonList.add(UtilES.getLinkedMapWritableFromObject((IDeepType)iterator.next()));
                }
                continue;
            }
            if (IDeepType.class.isAssignableFrom(field.getType())) {
                linkedMapWritable.put((Writable)new Text(AnnotationUtils.deepFieldName((Field)field)), (Writable)UtilES.getLinkedMapWritableFromObject((IDeepType)object));
                continue;
            }
            linkedMapWritable.put((Writable)new Text(AnnotationUtils.deepFieldName((Field)field)), UtilES.getWritableFromObject(object));
        }
        return linkedMapWritable;
    }

    public static <T extends IDeepType> Object getId(T t) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return null;
    }

    public static Cells getCellFromJson(LinkedMapWritable jsonObject, String tableName) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Cells cells = tableName != null ? new Cells(tableName) : new Cells();
        Set entryJson = jsonObject.entrySet();
        for (Map.Entry entry : entryJson) {
            if (LinkedMapWritable.class.isAssignableFrom(((Writable)entry.getValue()).getClass())) {
                Cells innerCells = UtilES.getCellFromJson((LinkedMapWritable)entry.getValue(), null);
                cells.add(Cell.create((String)((Writable)entry.getKey()).toString(), (Object)innerCells));
                continue;
            }
            if (ArrayWritable.class.isAssignableFrom(((Writable)entry.getValue()).getClass())) {
                Writable[] writetable = ((ArrayWritable)entry.getValue()).get();
                ArrayList<Object> innerCell = new ArrayList<Object>();
                for (int i = 0; i < writetable.length; ++i) {
                    if (writetable[i] instanceof LinkedMapWritable) {
                        innerCell.add(UtilES.getCellFromJson((LinkedMapWritable)writetable[i], null));
                        continue;
                    }
                    innerCell.add(UtilES.getObjectFromWritable((Writable)entry.getValue()));
                }
                cells.add(Cell.create((String)((Writable)entry.getKey()).toString(), innerCell));
                continue;
            }
            cells.add(Cell.create((String)((Writable)entry.getKey()).toString(), (Object)UtilES.getObjectFromWritable((Writable)entry.getValue())));
        }
        return cells;
    }

    private static Object getObjectFromWritable(Writable writable) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object object = null;
        if (writable instanceof NullWritable) {
            object = NullWritable.get();
        } else if (writable instanceof BooleanWritable) {
            object = ((BooleanWritable)writable).get();
        } else if (writable instanceof Text) {
            object = writable.toString();
        } else if (writable instanceof ByteWritable) {
            object = ((ByteWritable)writable).get();
        } else if (writable instanceof IntWritable) {
            object = ((IntWritable)writable).get();
        } else if (writable instanceof LongWritable) {
            object = ((LongWritable)writable).get();
        } else if (writable instanceof BytesWritable) {
            object = ((BytesWritable)writable).getBytes();
        } else if (writable instanceof DoubleWritable) {
            object = ((DoubleWritable)writable).get();
        } else if (writable instanceof FloatWritable) {
            object = Float.valueOf(((FloatWritable)writable).get());
        }
        return object;
    }

    private static Writable getWritableFromObject(Object object) {
        Object writable = null;
        writable = object instanceof String ? new Text(object.toString()) : (object instanceof Long ? new LongWritable(((Long)object).longValue()) : new IntWritable(((Integer)object).intValue()));
        return writable;
    }

    public static JSONObject getJsonFromCell(Cells cells) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        JSONObject json = new JSONObject();
        for (Cell cell : cells) {
            if (cell.getCellValue() == null) continue;
            if (Collection.class.isAssignableFrom(cell.getCellValue().getClass())) {
                Collection c = (Collection)cell.getCellValue();
                Iterator iterator = c.iterator();
                ArrayList<JSONObject> innerJsonList = new ArrayList<JSONObject>();
                while (iterator.hasNext()) {
                    innerJsonList.add(UtilES.getJsonFromCell((Cells)iterator.next()));
                }
                json.put((Object)cell.getCellName(), innerJsonList);
                continue;
            }
            if (Cells.class.isAssignableFrom(cell.getCellValue().getClass())) {
                json.put((Object)cell.getCellName(), (Object)UtilES.getJsonFromCell((Cells)cell.getCellValue()));
                continue;
            }
            json.put((Object)cell.getCellName(), cell.getCellValue());
        }
        return json;
    }

    public static QueryBuilder generateQuery(Filter ... filterArray) {
        ArrayList<Filter> range = new ArrayList<Filter>();
        ArrayList<Filter> ne = new ArrayList<Filter>();
        ArrayList<Filter> is = new ArrayList<Filter>();
        BoolQueryBuilder qb = QueryBuilders.boolQuery();
        for (Filter filter : filterArray) {
            if (!filter.getFilterType().equals((Object)FilterType.EQ) && !filter.getFilterType().equals((Object)FilterType.NEQ)) {
                range.add(filter);
                continue;
            }
            if (filter.getFilterType().equals((Object)FilterType.EQ)) {
                is.add(filter);
                continue;
            }
            ne.add(filter);
        }
        for (Filter filter : range) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)filter.getField());
            switch (filter.getFilterType()) {
                case LT: {
                    rangeQueryBuilder.lt((Object)filter.getValue());
                    break;
                }
                case LTE: {
                    rangeQueryBuilder.lte((Object)filter.getValue());
                    break;
                }
                case GT: {
                    rangeQueryBuilder.gt((Object)filter.getValue());
                    break;
                }
                case GTE: {
                    rangeQueryBuilder.gte((Object)filter.getValue());
                    break;
                }
            }
            qb.must((QueryBuilder)rangeQueryBuilder);
        }
        for (Filter filter : is) {
            qb.must((QueryBuilder)QueryBuilders.matchQuery((String)filter.getField(), (Object)filter.getValue()));
        }
        for (Filter filter : ne) {
            qb.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)filter.getField(), (Object)filter.getValue()));
        }
        return qb;
    }
}

