/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.streaming.api;

import com.stratio.streaming.api.StratioStreamingAPIConfig;
import com.stratio.streaming.api.StratioStreamingAPIConfig$class;
import com.stratio.streaming.api.StreamingAPIAsyncOperation;
import com.stratio.streaming.api.StreamingAPIListOperation;
import com.stratio.streaming.api.StreamingAPISyncOperation;
import com.stratio.streaming.commons.exceptions.StratioEngineStatusException;
import com.stratio.streaming.commons.kafka.service.KafkaTopicService;
import com.stratio.streaming.commons.kafka.service.TopicService;
import com.stratio.streaming.kafka.KafkaConsumer;
import com.stratio.streaming.kafka.KafkaProducer;
import com.stratio.streaming.kafka.KafkaProducer$;
import com.stratio.streaming.zookeeper.ZookeeperConsumer;
import com.typesafe.config.Config;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.retry.RetryOneTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StratioStreamingAPI$
implements StratioStreamingAPIConfig {
    public static final StratioStreamingAPI$ MODULE$;
    private Logger log;
    private final String streamingTopicName;
    private final String sessionId;
    private String brokerServer;
    private int brokerPort;
    private String kafkaBroker;
    private String zookeeperServer;
    private int zookeeperPort;
    private String zookeeperCluster;
    private boolean streamingUpAndRunning;
    private final Map<String, KafkaConsumer> streamingListeners;
    private KafkaProducer kafkaProducer;
    private final RetryOneTime retryPolicy;
    private CuratorFramework zookeeperClient;
    private TopicService topicService;
    private int ackTimeOut;
    private ZookeeperConsumer zookeeperConsumer;
    private StreamingAPISyncOperation syncOperation;
    private StreamingAPIAsyncOperation asyncOperation;
    private StreamingAPIListOperation statusOperation;
    private final Config config;
    private volatile int bitmap$0;

    static {
        new StratioStreamingAPI$();
    }

    private Logger log$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.log = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 |= 1;
            }
            return this.log;
        }
    }

    private String kafkaBroker$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.kafkaBroker = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerServer(), BoxesRunTime.boxToInteger((int)this.brokerPort())}));
                this.bitmap$0 |= 2;
            }
            return this.kafkaBroker;
        }
    }

    private String zookeeperCluster$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.zookeeperCluster = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zookeeperServer(), BoxesRunTime.boxToInteger((int)this.zookeeperPort())}));
                this.bitmap$0 |= 4;
            }
            return this.zookeeperCluster;
        }
    }

    private KafkaProducer kafkaProducer$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.kafkaProducer = new KafkaProducer("stratio_streaming_requests", this.kafkaBroker(), KafkaProducer$.MODULE$.$lessinit$greater$default$3(), KafkaProducer$.MODULE$.$lessinit$greater$default$4(), KafkaProducer$.MODULE$.$lessinit$greater$default$5(), KafkaProducer$.MODULE$.$lessinit$greater$default$6(), KafkaProducer$.MODULE$.$lessinit$greater$default$7(), KafkaProducer$.MODULE$.$lessinit$greater$default$8());
                this.bitmap$0 |= 8;
            }
            return this.kafkaProducer;
        }
    }

    private CuratorFramework zookeeperClient$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.zookeeperClient = CuratorFrameworkFactory.newClient((String)this.zookeeperCluster(), (RetryPolicy)this.retryPolicy());
                this.bitmap$0 |= 0x10;
            }
            return this.zookeeperClient;
        }
    }

    private ZookeeperConsumer zookeeperConsumer$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.zookeeperClient().start();
                this.zookeeperConsumer = new ZookeeperConsumer(this.zookeeperClient());
                this.bitmap$0 |= 0x20;
            }
            return this.zookeeperConsumer;
        }
    }

    private StreamingAPISyncOperation syncOperation$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.syncOperation = new StreamingAPISyncOperation(this.kafkaProducer(), this.zookeeperConsumer(), this.ackTimeOut());
                this.bitmap$0 |= 0x40;
            }
            return this.syncOperation;
        }
    }

    private StreamingAPIAsyncOperation asyncOperation$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.asyncOperation = new StreamingAPIAsyncOperation(this.kafkaProducer());
                this.bitmap$0 |= 0x80;
            }
            return this.asyncOperation;
        }
    }

    private StreamingAPIListOperation statusOperation$lzycompute() {
        StratioStreamingAPI$ stratioStreamingAPI$ = this;
        synchronized (stratioStreamingAPI$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.statusOperation = new StreamingAPIListOperation(this.kafkaProducer(), this.zookeeperConsumer(), this.ackTimeOut());
                this.bitmap$0 |= 0x100;
            }
            return this.statusOperation;
        }
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public void com$stratio$streaming$api$StratioStreamingAPIConfig$_setter_$config_$eq(Config x$1) {
        this.config = x$1;
    }

    public Logger log() {
        return (this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    public String streamingTopicName() {
        return this.streamingTopicName;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public String brokerServer() {
        return this.brokerServer;
    }

    public void brokerServer_$eq(String x$1) {
        this.brokerServer = x$1;
    }

    public int brokerPort() {
        return this.brokerPort;
    }

    public void brokerPort_$eq(int x$1) {
        this.brokerPort = x$1;
    }

    public String kafkaBroker() {
        return (this.bitmap$0 & 2) == 0 ? this.kafkaBroker$lzycompute() : this.kafkaBroker;
    }

    public String zookeeperServer() {
        return this.zookeeperServer;
    }

    public void zookeeperServer_$eq(String x$1) {
        this.zookeeperServer = x$1;
    }

    public int zookeeperPort() {
        return this.zookeeperPort;
    }

    public void zookeeperPort_$eq(int x$1) {
        this.zookeeperPort = x$1;
    }

    public String zookeeperCluster() {
        return (this.bitmap$0 & 4) == 0 ? this.zookeeperCluster$lzycompute() : this.zookeeperCluster;
    }

    public boolean streamingUpAndRunning() {
        return this.streamingUpAndRunning;
    }

    public void streamingUpAndRunning_$eq(boolean x$1) {
        this.streamingUpAndRunning = x$1;
    }

    public Map<String, KafkaConsumer> streamingListeners() {
        return this.streamingListeners;
    }

    public KafkaProducer kafkaProducer() {
        return (this.bitmap$0 & 8) == 0 ? this.kafkaProducer$lzycompute() : this.kafkaProducer;
    }

    public RetryOneTime retryPolicy() {
        return this.retryPolicy;
    }

    public CuratorFramework zookeeperClient() {
        return (this.bitmap$0 & 0x10) == 0 ? this.zookeeperClient$lzycompute() : this.zookeeperClient;
    }

    public TopicService topicService() {
        return this.topicService;
    }

    public void topicService_$eq(TopicService x$1) {
        this.topicService = x$1;
    }

    public int ackTimeOut() {
        return this.ackTimeOut;
    }

    public void ackTimeOut_$eq(int x$1) {
        this.ackTimeOut = x$1;
    }

    public ZookeeperConsumer zookeeperConsumer() {
        return (this.bitmap$0 & 0x20) == 0 ? this.zookeeperConsumer$lzycompute() : this.zookeeperConsumer;
    }

    public StreamingAPISyncOperation syncOperation() {
        return (this.bitmap$0 & 0x40) == 0 ? this.syncOperation$lzycompute() : this.syncOperation;
    }

    public StreamingAPIAsyncOperation asyncOperation() {
        return (this.bitmap$0 & 0x80) == 0 ? this.asyncOperation$lzycompute() : this.asyncOperation;
    }

    public StreamingAPIListOperation statusOperation() {
        return (this.bitmap$0 & 0x100) == 0 ? this.statusOperation$lzycompute() : this.statusOperation;
    }

    public void checkEphemeralNode() {
        String ephemeralNodePath = "/stratio/streaming/engine";
        if (this.zookeeperConsumer().zNodeExists(ephemeralNodePath)) {
            this.streamingUpAndRunning_$eq(true);
            return;
        }
        this.log().warn("Ephemeral node does not exist");
        throw new StratioEngineStatusException("Stratio streaming is down");
    }

    public void startEphemeralNodeWatch() {
        ((Pathable)this.zookeeperClient().checkExists().watched()).forPath("/stratio/streaming/engine");
        this.addListener();
    }

    public void initializeTopic() {
        this.topicService_$eq((TopicService)new KafkaTopicService(this.zookeeperCluster(), this.brokerServer(), this.brokerPort(), 10000, 10000));
        this.topicService().createTopicIfNotExist(this.streamingTopicName(), 1, 1);
    }

    public void checkStreamingStatus() {
        if (this.streamingUpAndRunning()) {
            return;
        }
        throw new StratioEngineStatusException("Stratio streaming is down");
    }

    public void addListener() {
        this.zookeeperClient().getCuratorListenable().addListener((Object)new CuratorListener(){

            public void eventReceived(CuratorFramework client, CuratorEvent event) {
                CuratorEventType curatorEventType;
                block2: {
                    boolean bl;
                    block5: {
                        block4: {
                            block3: {
                                curatorEventType = event.getType();
                                CuratorEventType curatorEventType2 = CuratorEventType.WATCHED;
                                CuratorEventType curatorEventType3 = curatorEventType;
                                if (curatorEventType2 != null ? !curatorEventType2.equals(curatorEventType3) : curatorEventType3 != null) break block2;
                                ((Pathable)StratioStreamingAPI$.MODULE$.zookeeperClient().checkExists().watched()).forPath("/stratio/streaming/engine");
                                bl = StratioStreamingAPI$.MODULE$.zookeeperConsumer().zNodeExists("/stratio/streaming/engine");
                                if (!bl) break block3;
                                StratioStreamingAPI$.MODULE$.streamingUpAndRunning_$eq(true);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (bl) break block5;
                            StratioStreamingAPI$.MODULE$.streamingUpAndRunning_$eq(false);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                throw new MatchError((Object)curatorEventType);
            }
        });
    }

    private StratioStreamingAPI$() {
        MODULE$ = this;
        StratioStreamingAPIConfig$class.$init$(this);
        this.streamingTopicName = "stratio_streaming_requests";
        this.sessionId = String.valueOf(BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        this.brokerServer = "";
        this.brokerPort = 0;
        this.zookeeperServer = "";
        this.zookeeperPort = 0;
        this.streamingUpAndRunning = false;
        this.streamingListeners = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.retryPolicy = new RetryOneTime(500);
        this.ackTimeOut = 8000;
    }
}

