/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.streaming.api;

import com.google.gson.Gson;
import com.stratio.streaming.api.StreamingAPIOperation;
import com.stratio.streaming.api.StreamingAPISyncOperation$;
import com.stratio.streaming.commons.constants.REPLY_CODES;
import com.stratio.streaming.commons.dto.ActionCallbackDto;
import com.stratio.streaming.commons.exceptions.StratioAPIGenericException;
import com.stratio.streaming.commons.exceptions.StratioAPISecurityException;
import com.stratio.streaming.commons.exceptions.StratioEngineOperationException;
import com.stratio.streaming.commons.messages.StratioStreamingMessage;
import com.stratio.streaming.kafka.KafkaProducer;
import com.stratio.streaming.zookeeper.ZookeeperConsumer;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u0001.\u0011\u0011d\u0015;sK\u0006l\u0017N\\4B!&\u001b\u0016P\\2Pa\u0016\u0014\u0018\r^5p]*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u000591\u000f\u001e:bi&|'\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001a\u0001C\u0006\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011Qc\u0015;sK\u0006l\u0017N\\4B!&{\u0005/\u001a:bi&|g\u000e\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"CA\u0004Qe>$Wo\u0019;\u0011\u0005E9\u0012B\u0001\r\u0013\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Q\u0002A!f\u0001\n\u0003Y\u0012!D6bM.\f\u0007K]8ek\u000e,'/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\tyB!A\u0003lC\u001a\\\u0017-\u0003\u0002\"=\ti1*\u00194lCB\u0013x\u000eZ;dKJD\u0001b\t\u0001\u0003\u0012\u0003\u0006I\u0001H\u0001\u000fW\u000647.\u0019)s_\u0012,8-\u001a:!\u0011!)\u0003A!f\u0001\n\u00031\u0013!\u0005>p_.,W\r]3s\u0007>t7/^7feV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\t\u0005I!p\\8lK\u0016\u0004XM]\u0005\u0003Y%\u0012\u0011CW8pW\u0016,\u0007/\u001a:D_:\u001cX/\\3s\u0011!q\u0003A!E!\u0002\u00139\u0013A\u0005>p_.,W\r]3s\u0007>t7/^7fe\u0002B\u0001\u0002\r\u0001\u0003\u0016\u0004%\t!M\u0001\u000fC\u000e\\G+[7f\u001fV$\u0018J\\'t+\u0005\u0011\u0004CA\t4\u0013\t!$CA\u0002J]RD\u0001B\u000e\u0001\u0003\u0012\u0003\u0006IAM\u0001\u0010C\u000e\\G+[7f\u001fV$\u0018J\\'tA!)\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"BAO\u001e={A\u0011Q\u0002\u0001\u0005\u00065]\u0002\r\u0001\b\u0005\u0006K]\u0002\ra\n\u0005\u0006a]\u0002\rA\r\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0015a\u0016\u0014hm\u001c:n'ft7m\u00149fe\u0006$\u0018n\u001c8\u0015\u0005\u0005#\u0005CA\tC\u0013\t\u0019%C\u0001\u0003V]&$\b\"B#?\u0001\u00041\u0015aB7fgN\fw-\u001a\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b\u0001\"\\3tg\u0006<Wm\u001d\u0006\u0003\u0017\u0012\tqaY8n[>t7/\u0003\u0002N\u0011\n92\u000b\u001e:bi&|7\u000b\u001e:fC6LgnZ'fgN\fw-\u001a\u0005\u0006\u001f\u0002!I\u0001U\u0001\u0018[\u0006t\u0017mZ3TiJ,\u0017-\\5oOJ+7\u000f]8og\u0016$2!Q)[\u0011\u0015\u0011f\n1\u0001T\u0003!\u0011Xm\u001d9p]N,\u0007C\u0001+X\u001d\t\tR+\u0003\u0002W%\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1&\u0003C\u0003F\u001d\u0002\u0007a\tC\u0003]\u0001\u0011%Q,\u0001\bde\u0016\fG/\u001a'pO\u0016\u0013(o\u001c:\u0015\u0007\u0005s\u0006\rC\u0003`7\u0002\u0007!'\u0001\u0007sKN\u0004xN\\:f\u0007>$W\rC\u0003b7\u0002\u00071+\u0001\tfeJ|'\u000fR3tGJL\u0007\u000f^5p]\")1\r\u0001C\u0005I\u00061\u0002/\u0019:tKRCW-\u00128hS:,'+Z:q_:\u001cX\r\u0006\u0002f]B\u0019\u0011C\u001a5\n\u0005\u001d\u0014\"AB(qi&|g\u000e\u0005\u0002jY6\t!N\u0003\u0002l\u0015\u0006\u0019A\r^8\n\u00055T'!E!di&|gnQ1mY\n\f7m\u001b#u_\")!K\u0019a\u0001'\"9\u0001\u000fAA\u0001\n\u0003\t\u0018\u0001B2paf$BA\u000f:ti\"9!d\u001cI\u0001\u0002\u0004a\u0002bB\u0013p!\u0003\u0005\ra\n\u0005\ba=\u0004\n\u00111\u00013\u0011\u001d1\b!%A\u0005\u0002]\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001yU\ta\u0012pK\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\nk:\u001c\u0007.Z2lK\u0012T!a \n\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\u0004q\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\u0001AI\u0001\n\u0003\tI!\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-!FA\u0014z\u0011%\ty\u0001AI\u0001\n\u0003\t\t\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M!F\u0001\u001az\u0011%\t9\u0002AA\u0001\n\u0003\nI\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0003mC:<'BAA\u0013\u0003\u0011Q\u0017M^1\n\u0007a\u000by\u0002\u0003\u0005\u0002,\u0001\t\t\u0011\"\u00012\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\ty\u0003AA\u0001\n\u0003\t\t$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005M\u0012\u0011\b\t\u0004#\u0005U\u0012bAA\u001c%\t\u0019\u0011I\\=\t\u0013\u0005m\u0012QFA\u0001\u0002\u0004\u0011\u0014a\u0001=%c!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011I\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\t\t\u0007\u0003\u000b\nY%a\r\u000e\u0005\u0005\u001d#bAA%%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0013q\t\u0002\t\u0013R,'/\u0019;pe\"I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111K\u0001\tG\u0006tW)];bYR!\u0011QKA.!\r\t\u0012qK\u0005\u0004\u00033\u0012\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003w\ty%!AA\u0002\u0005M\u0002\"CA0\u0001\u0005\u0005I\u0011IA1\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u001a\t\u0013\u0005\u0015\u0004!!A\u0005B\u0005\u001d\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0001\"CA6\u0001\u0005\u0005I\u0011IA7\u0003\u0019)\u0017/^1mgR!\u0011QKA8\u0011)\tY$!\u001b\u0002\u0002\u0003\u0007\u00111G\u0004\n\u0003g\u0012\u0011\u0011!E\u0001\u0003k\n\u0011d\u0015;sK\u0006l\u0017N\\4B!&\u001b\u0016P\\2Pa\u0016\u0014\u0018\r^5p]B\u0019Q\"a\u001e\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003s\u001aR!a\u001e\u0002|Y\u0001\u0002\"! \u0002\u0004r9#GO\u0007\u0003\u0003\u007fR1!!!\u0013\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\"\u0002\u0000\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fa\n9\b\"\u0001\u0002\nR\u0011\u0011Q\u000f\u0005\u000b\u0003K\n9(!A\u0005F\u0005\u001d\u0004BCAH\u0003o\n\t\u0011\"!\u0002\u0012\u0006)\u0011\r\u001d9msR9!(a%\u0002\u0016\u0006]\u0005B\u0002\u000e\u0002\u000e\u0002\u0007A\u0004\u0003\u0004&\u0003\u001b\u0003\ra\n\u0005\u0007a\u00055\u0005\u0019\u0001\u001a\t\u0015\u0005m\u0015qOA\u0001\n\u0003\u000bi*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u0015q\u0015\t\u0005#\u0019\f\t\u000b\u0005\u0004\u0012\u0003GcrEM\u0005\u0004\u0003K\u0013\"A\u0002+va2,7\u0007C\u0005\u0002*\u0006e\u0015\u0011!a\u0001u\u0005\u0019\u0001\u0010\n\u0019\t\u0015\u00055\u0016qOA\u0001\n\u0013\ty+A\u0006sK\u0006$'+Z:pYZ,GCAAY!\u0011\ti\"a-\n\t\u0005U\u0016q\u0004\u0002\u0007\u001f\nTWm\u0019;")
public class StreamingAPISyncOperation
extends StreamingAPIOperation
implements Product,
Serializable {
    private final KafkaProducer kafkaProducer;
    private final ZookeeperConsumer zookeeperConsumer;
    private final int ackTimeOutInMs;

    public static Function1<Tuple3<KafkaProducer, ZookeeperConsumer, Object>, StreamingAPISyncOperation> tupled() {
        return StreamingAPISyncOperation$.MODULE$.tupled();
    }

    public static Function1<KafkaProducer, Function1<ZookeeperConsumer, Function1<Object, StreamingAPISyncOperation>>> curried() {
        return StreamingAPISyncOperation$.MODULE$.curried();
    }

    public KafkaProducer kafkaProducer() {
        return this.kafkaProducer;
    }

    public ZookeeperConsumer zookeeperConsumer() {
        return this.zookeeperConsumer;
    }

    public int ackTimeOutInMs() {
        return this.ackTimeOutInMs;
    }

    public void performSyncOperation(StratioStreamingMessage message) {
        String zNodeUniqueId = UUID.randomUUID().toString();
        this.addMessageToKafkaTopic(message, zNodeUniqueId, this.kafkaProducer());
        String syncOperationResponse = this.waitForTheStreamingResponse(this.zookeeperConsumer(), message, this.ackTimeOutInMs());
        this.manageStreamingResponse(syncOperationResponse, message);
    }

    /*
     * WARNING - void declaration
     */
    private void manageStreamingResponse(String response, StratioStreamingMessage message) {
        Option<ActionCallbackDto> responseDto;
        Option<ActionCallbackDto> option = responseDto = this.parseTheEngineResponse(response);
        None$ none$ = None$.MODULE$;
        Option<ActionCallbackDto> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new StratioAPIGenericException("StratioEngine error: Unable to parse the engine response");
        }
        if (option instanceof Some) {
            void var10_9;
            void var9_8;
            boolean bl;
            Some some = (Some)option;
            ActionCallbackDto responseDto2 = (ActionCallbackDto)some.x();
            Integer replyCode = responseDto2.getErrorCode();
            String replyDescription = responseDto2.getDescription();
            Integer n = replyCode;
            Integer n2 = REPLY_CODES.OK;
            Integer n3 = n;
            if (!(n2 != null ? !((Object)n2).equals(n3) : n3 != null)) {
                String messageOperation = message.getOperation();
                String streamName = message.getStreamName();
                this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"StratioEngine Ack received for the operation ", " on the ", " stream"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{messageOperation, streamName})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
            Integer n4 = REPLY_CODES.KO_STREAM_OPERATION_NOT_ALLOWED;
            Integer n5 = n;
            if (!(n4 != null ? !((Object)n4).equals(n5) : n5 != null)) {
                bl = true;
            } else {
                Integer n6 = REPLY_CODES.KO_STREAM_IS_NOT_USER_DEFINED;
                Integer n7 = n;
                bl = !(n6 != null ? !((Object)n6).equals(n7) : n7 != null);
            }
            if (bl) {
                this.createLogError(Predef$.MODULE$.Integer2int((Integer)var9_8), (String)var10_9);
                throw new StratioAPISecurityException((String)var10_9);
            }
            this.createLogError(Predef$.MODULE$.Integer2int((Integer)var9_8), (String)var10_9);
            throw new StratioEngineOperationException(new StringBuilder().append((Object)"StratioEngine error: ").append((Object)var10_9).toString());
        }
        throw new MatchError(option);
    }

    private void createLogError(int responseCode, String errorDescription) {
        this.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"StratioAPI - [ACK_CODE,QUERY_STRING]: [", ",", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)responseCode), errorDescription})));
    }

    private Option<ActionCallbackDto> parseTheEngineResponse(String response) {
        None$ none$;
        try {
            ActionCallbackDto parsedResponse = (ActionCallbackDto)new Gson().fromJson(response, ActionCallbackDto.class);
            Integer n = parsedResponse.getErrorCode();
            Object object = n == null ? None$.MODULE$ : new Some((Object)parsedResponse);
            none$ = object;
        }
        catch (Throwable throwable) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public StreamingAPISyncOperation copy(KafkaProducer kafkaProducer, ZookeeperConsumer zookeeperConsumer, int ackTimeOutInMs) {
        return new StreamingAPISyncOperation(kafkaProducer, zookeeperConsumer, ackTimeOutInMs);
    }

    public KafkaProducer copy$default$1() {
        return this.kafkaProducer();
    }

    public ZookeeperConsumer copy$default$2() {
        return this.zookeeperConsumer();
    }

    public int copy$default$3() {
        return this.ackTimeOutInMs();
    }

    public String productPrefix() {
        return "StreamingAPISyncOperation";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.ackTimeOutInMs());
                break;
            }
            case 1: {
                object = this.zookeeperConsumer();
                break;
            }
            case 0: {
                object = this.kafkaProducer();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StreamingAPISyncOperation;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.kafkaProducer()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.zookeeperConsumer()));
        n = Statics.mix((int)n, (int)this.ackTimeOutInMs());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StreamingAPISyncOperation)) return false;
        boolean bl = true;
        if (!bl) return false;
        StreamingAPISyncOperation streamingAPISyncOperation = (StreamingAPISyncOperation)x$1;
        KafkaProducer kafkaProducer = this.kafkaProducer();
        KafkaProducer kafkaProducer2 = streamingAPISyncOperation.kafkaProducer();
        if (kafkaProducer == null) {
            if (kafkaProducer2 != null) {
                return false;
            }
        } else if (!((Object)kafkaProducer).equals(kafkaProducer2)) return false;
        ZookeeperConsumer zookeeperConsumer = this.zookeeperConsumer();
        ZookeeperConsumer zookeeperConsumer2 = streamingAPISyncOperation.zookeeperConsumer();
        if (zookeeperConsumer == null) {
            if (zookeeperConsumer2 != null) {
                return false;
            }
        } else if (!((Object)zookeeperConsumer).equals(zookeeperConsumer2)) return false;
        if (this.ackTimeOutInMs() != streamingAPISyncOperation.ackTimeOutInMs()) return false;
        if (!streamingAPISyncOperation.canEqual(this)) return false;
        return true;
    }

    public StreamingAPISyncOperation(KafkaProducer kafkaProducer, ZookeeperConsumer zookeeperConsumer, int ackTimeOutInMs) {
        this.kafkaProducer = kafkaProducer;
        this.zookeeperConsumer = zookeeperConsumer;
        this.ackTimeOutInMs = ackTimeOutInMs;
        Product.class.$init$((Product)this);
    }
}

