/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.streaming.commons.messages;

import com.google.common.collect.Lists;
import com.stratio.streaming.commons.constants.StreamAction;
import com.stratio.streaming.commons.messages.ColumnNameTypeValue;
import com.stratio.streaming.commons.messages.StreamQuery;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class StratioStreamingMessage
implements Serializable {
    private static final long serialVersionUID = -3259551728685320551L;
    private String operation;
    private String streamName;
    private String session_id;
    private String request_id;
    private String request;
    private Long timestamp;
    private List<ColumnNameTypeValue> columns;
    private List<StreamQuery> queries;
    private Set<StreamAction> activeActions;
    private Boolean userDefined;

    public StratioStreamingMessage() {
    }

    public StratioStreamingMessage(String operation, String streamName, String sessionId, String requestId, String request, Long timeStamp, List<ColumnNameTypeValue> columns, List<StreamQuery> queries, Boolean userDefined) {
        this.operation = operation;
        this.streamName = streamName;
        this.session_id = sessionId;
        this.request_id = requestId;
        this.request = request;
        this.timestamp = timeStamp;
        this.columns = columns;
        this.queries = queries;
        this.userDefined = userDefined;
    }

    public StratioStreamingMessage(String streamName, List<ColumnNameTypeValue> columns, List<StreamQuery> queries) {
        this.streamName = streamName;
        this.columns = columns;
        this.queries = queries;
    }

    public StratioStreamingMessage(String streamName, Long timestamp, List<ColumnNameTypeValue> columns) {
        this.streamName = streamName;
        this.timestamp = timestamp;
        this.columns = columns;
    }

    public void addColumn(ColumnNameTypeValue column) {
        if (this.columns == null) {
            this.columns = Lists.newArrayList();
        }
        this.columns.add(column);
    }

    public void addQuery(StreamQuery query) {
        if (this.queries == null) {
            this.queries = Lists.newArrayList();
        }
        this.queries.add(query);
    }

    public String getRequest_id() {
        return this.request_id;
    }

    public void setRequest_id(String request_id) {
        this.request_id = request_id;
    }

    public Boolean isUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(Boolean userDefined) {
        this.userDefined = userDefined;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getSession_id() {
        return this.session_id;
    }

    public void setSession_id(String session_id) {
        this.session_id = session_id;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public List<ColumnNameTypeValue> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnNameTypeValue> columns) {
        this.columns = columns;
    }

    public List<StreamQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<StreamQuery> queries) {
        this.queries = queries;
    }

    public Set<StreamAction> getActiveActions() {
        return this.activeActions;
    }

    public void setActiveActions(Set<StreamAction> activeActions) {
        this.activeActions = activeActions;
    }
}

