/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.extensions.avatar.renderkit;

import com.sun.faces.extensions.avatar.components.AjaxZone;
import com.sun.faces.extensions.avatar.lifecycle.AsyncResponse;
import com.sun.faces.extensions.common.util.Util;
import java.beans.Beans;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class AjaxZoneRenderer
extends Renderer {
    private static final String[] scriptIds = new String[]{"/META-INF/libs/scriptaculous/version1.6.4/prototype", "/META-INF/0.1-SNAPSHOT-rc8/com_sun_faces_ajax", "/META-INF/0.1-SNAPSHOT-rc8/com_sun_faces_ajax_zone"};
    private static final String[] scriptLinkKeys = new String[]{"com.sun.faces.extensions.avatar.LINKED/prototype.js", "com.sun.faces.extensions.avatar.LINKED/com_sun_faces_ajax.js", "com.sun.faces.extensions.avatar.LINKED/com_sun_faces_ajax_zone.js"};
    private boolean didInit = false;
    private transient XhtmlHelper xHtmlHelper = null;

    public void init() {
        if (!this.didInit) {
            String maxValue = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("com.sun.faces.extensions.MAXIMIZE_RESOURCES");
            boolean doMax = null != maxValue && 0 < maxValue.length();
            for (int i = 0; i < scriptIds.length; ++i) {
                AjaxZoneRenderer.scriptIds[i] = doMax ? scriptIds[i] + "-max.js" : scriptIds[i] + ".js";
            }
            this.didInit = true;
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String value = (String)requestParameterMap.get(clientId);
        if (value == null && requestParameterMap.get(clientId + ".x") == null && requestParameterMap.get(clientId + ".y") == null) {
            return;
        }
        String type = (String)component.getAttributes().get("type");
        if (type != null && type.toLowerCase().equals("reset")) {
            return;
        }
        ActionEvent actionEvent = new ActionEvent(component);
        component.queueEvent((FacesEvent)actionEvent);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.init();
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(FacesContext.getCurrentInstance());
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)id, null);
        this.writeStyle(context, writer, component, false);
        this.writeStyle(context, writer, component, true);
    }

    private void writeStyle(FacesContext context, ResponseWriter writer, UIComponent comp, boolean isStyleClass) throws IOException {
        String styleValue = null;
        ValueExpression styleExp = null;
        String styleProperty = isStyleClass ? "styleClass" : "style";
        styleValue = (String)comp.getAttributes().get(styleProperty);
        if (null == styleValue && null != (styleExp = comp.getValueExpression(styleProperty))) {
            styleValue = (String)styleExp.getValue(context.getELContext());
        }
        if (null != styleValue) {
            writer.writeAttribute(styleProperty, (Object)styleValue, styleProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAjaxifyScripts(FacesContext context, ResponseWriter writer, AjaxZone comp, boolean isAjaxRequest) throws IOException {
        String clientId = null;
        String getCallbackData = null;
        String collectPostData = null;
        String eventType = null;
        String inspectElement = null;
        String replaceElement = null;
        String postReplace = null;
        String execute = null;
        String render = null;
        StringBuffer ajaxifyChildren = null;
        MethodExpression action = null;
        try {
            boolean typeIsOutput;
            InteractionType interactionType;
            writer.startElement("script", (UIComponent)comp);
            writer.writeAttribute("language", (Object)"javascript", "language");
            writer.writeAttribute("type", (Object)"text/javascript", "language");
            List<AjaxZone> zoneList = comp.getAllZoneList();
            writer.write("\nvar curZone = null;\n");
            for (AjaxZone currentZone : zoneList) {
                boolean writeZoneAccruer;
                interactionType = this.getInteractionType(context, currentZone);
                typeIsOutput = interactionType == InteractionType.output;
                boolean bl = writeZoneAccruer = !isAjaxRequest && typeIsOutput || !isAjaxRequest && !typeIsOutput;
                if (!currentZone.isRendered() || isAjaxRequest && typeIsOutput) continue;
                clientId = currentZone.getClientId(context);
                if (writeZoneAccruer) {
                    writer.write("\nDynaFacesZones.g_zones.push(\"" + clientId + "\");");
                }
                execute = this.getAttr(context, (UIComponent)currentZone, "execute");
                render = this.getAttr(context, (UIComponent)currentZone, "render");
                if (null != execute || null != render) {
                    writer.write("\ncurZone = document.getElementById(\"" + clientId + "\");");
                }
                if (null != execute) {
                    writer.write("\ncurZone[\"execute\"] = \"" + execute + "\";");
                }
                if (null == render) continue;
                writer.write("\ncurZone[\"render\"] = \"" + render + "\";");
            }
            for (AjaxZone currentZone : zoneList) {
                boolean writeAjaxifyChildren;
                interactionType = this.getInteractionType(context, currentZone);
                typeIsOutput = interactionType == InteractionType.output;
                boolean bl = writeAjaxifyChildren = !isAjaxRequest && !typeIsOutput || isAjaxRequest && !typeIsOutput;
                if (!currentZone.isRendered() || isAjaxRequest && typeIsOutput) continue;
                clientId = currentZone.getClientId(context);
                if (!writeAjaxifyChildren) continue;
                boolean wroteAttribute = false;
                collectPostData = this.getAttr(context, (UIComponent)currentZone, "collectPostData");
                eventType = this.getAttr(context, (UIComponent)currentZone, "eventType");
                getCallbackData = this.getAttr(context, (UIComponent)currentZone, "getCallbackData");
                inspectElement = this.getAttr(context, (UIComponent)currentZone, "inspectElement");
                replaceElement = this.getAttr(context, (UIComponent)currentZone, "replaceElement");
                postReplace = this.getAttr(context, (UIComponent)currentZone, "postReplace");
                ajaxifyChildren = new StringBuffer();
                ajaxifyChildren.append("\nDynaFacesZones.ajaxifyChildren($('" + clientId + "'), ");
                ajaxifyChildren.append("{ ");
                if (null != collectPostData) {
                    wroteAttribute = true;
                    ajaxifyChildren.append(" collectPostData: '" + collectPostData + "'");
                }
                if (null != eventType) {
                    if (wroteAttribute) {
                        ajaxifyChildren.append(", ");
                    }
                    wroteAttribute = true;
                    ajaxifyChildren.append("eventType: '" + eventType + "'");
                }
                if (null != inspectElement) {
                    if (wroteAttribute) {
                        ajaxifyChildren.append(", ");
                    }
                    wroteAttribute = true;
                    ajaxifyChildren.append("inspectElement: '" + inspectElement + "'");
                }
                if (null != replaceElement) {
                    if (wroteAttribute) {
                        ajaxifyChildren.append(", ");
                    }
                    wroteAttribute = true;
                    ajaxifyChildren.append("replaceElement: '" + replaceElement + "'");
                }
                if (null != postReplace) {
                    if (wroteAttribute) {
                        ajaxifyChildren.append(", ");
                    }
                    wroteAttribute = true;
                    ajaxifyChildren.append("postReplace: '" + postReplace + "'");
                }
                if (null != (action = currentZone.getActionExpression())) {
                    if (wroteAttribute) {
                        ajaxifyChildren.append(", ");
                    }
                    wroteAttribute = true;
                    ajaxifyChildren.append("action: '" + action.getExpressionString() + "'");
                }
                ajaxifyChildren.append(" }");
                if (null != getCallbackData) {
                    ajaxifyChildren.append(", '" + getCallbackData + "'");
                }
                ajaxifyChildren.append(");");
                writer.write(ajaxifyChildren.toString());
            }
        }
        finally {
            writer.endElement("script");
        }
    }

    private InteractionType getInteractionType(FacesContext context, final AjaxZone component) {
        Util.TreeTraversalCallback findEditableValueHolder = new Util.TreeTraversalCallback(){

            public boolean takeActionOnNode(FacesContext context, UIComponent curNode) throws FacesException {
                boolean keepGoing = true;
                if (curNode != component && (curNode instanceof EditableValueHolder || curNode instanceof ActionSource)) {
                    keepGoing = false;
                }
                return keepGoing;
            }
        };
        InteractionType result = Util.prefixViewTraversal((FacesContext)context, (UIComponent)component, (Util.TreeTraversalCallback)findEditableValueHolder) ? InteractionType.output : InteractionType.input;
        return result;
    }

    private String getAttr(FacesContext context, UIComponent comp, String name) {
        String result = null;
        ValueExpression ve = comp.getValueExpression(name);
        if (null != ve) {
            result = (String)ve.getValue(context.getELContext());
        }
        if (null == result && null == (result = (String)comp.getAttributes().get(name))) {
            return null;
        }
        return result;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        for (UIComponent kid : component.getChildren()) {
            if (!kid.isRendered()) continue;
            kid.encodeAll(context);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        AjaxZone zone = (AjaxZone)component;
        boolean isAjaxRequest = AsyncResponse.isAjaxRequest();
        if (this.isRenderScriptsForAllZonesRightNow(context, zone, isAjaxRequest)) {
            if (!isAjaxRequest && !Beans.isDesignTime()) {
                for (int i = 0; i < scriptIds.length; ++i) {
                    Map requestMap = context.getExternalContext().getRequestMap();
                    if (requestMap.containsKey(scriptLinkKeys[i])) continue;
                    this.getXhtmlHelper().linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, scriptIds[i]);
                    requestMap.put(scriptLinkKeys[i], Boolean.TRUE);
                }
            }
            this.writeAjaxifyScripts(context, writer, zone, isAjaxRequest);
        }
        writer.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    private XhtmlHelper getXhtmlHelper() {
        if (null == this.xHtmlHelper) {
            this.xHtmlHelper = new XhtmlHelper();
        }
        return this.xHtmlHelper;
    }

    private boolean isRenderScriptsForAllZonesRightNow(FacesContext context, AjaxZone currentZone, boolean isAjaxRequest) {
        List<AjaxZone> zoneList;
        boolean result = false;
        List<AjaxZone> list = zoneList = isAjaxRequest ? currentZone.getRenderedZoneList() : currentZone.getAllZoneList();
        if (null != zoneList && !zoneList.isEmpty()) {
            AjaxZone lastRenderedZone = null;
            for (int i = zoneList.size() - 1; i >= 0 && !(lastRenderedZone = zoneList.get(i)).isRendered(); --i) {
                lastRenderedZone = null;
            }
            if (null != lastRenderedZone) {
                result = currentZone == lastRenderedZone;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InteractionType {
        input,
        output;

    }
}

