/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.signature;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.oauth.signature.Methods;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import com.sun.jersey.oauth.signature.OAuthSignatureMethod;
import com.sun.jersey.oauth.signature.UnsupportedSignatureMethodException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class OAuthSignature {
    public static String generate(OAuthRequest request, OAuthParameters params, OAuthSecrets secrets) throws OAuthSignatureException {
        return OAuthSignature.getSignatureMethod(params).sign(OAuthSignature.elements(request, params), secrets);
    }

    public static void sign(OAuthRequest request, OAuthParameters params, OAuthSecrets secrets) throws OAuthSignatureException {
        params = (OAuthParameters)params.clone();
        params.setSignature(OAuthSignature.generate(request, params, secrets));
        params.writeRequest(request);
    }

    public static boolean verify(OAuthRequest request, OAuthParameters params, OAuthSecrets secrets) throws OAuthSignatureException {
        return OAuthSignature.getSignatureMethod(params).verify(OAuthSignature.elements(request, params), secrets, params.getSignature());
    }

    static String normalizeParameters(OAuthRequest request, OAuthParameters params) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (String key : params.keySet()) {
            String value;
            if (key.equals("realm") || key.equals("oauth_signature") || (value = (String)params.get(key)) == null) continue;
            OAuthSignature.addParam(key, value, list);
        }
        for (String key : request.getParameterNames()) {
            List<String> values;
            if (key.startsWith("oauth_") && params.containsKey(key) || (values = request.getParameterValues(key)) == null) continue;
            for (String value : values) {
                OAuthSignature.addParam(key, value, list);
            }
        }
        Collections.sort(list, new Comparator<String[]>(){

            @Override
            public int compare(String[] t, String[] t1) {
                int c = t[0].compareTo(t1[0]);
                return c == 0 ? t[1].compareTo(t1[1]) : c;
            }
        });
        StringBuilder buf = new StringBuilder();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            String[] param = (String[])i.next();
            buf.append(param[0]).append("=").append(param[1]);
            if (!i.hasNext()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    private static URI constructRequestURL(OAuthRequest request) throws OAuthSignatureException {
        try {
            URL url = request.getRequestURL();
            if (url == null) {
                throw new OAuthSignatureException();
            }
            StringBuffer buf = new StringBuffer(url.getProtocol()).append("://").append(url.getHost().toLowerCase());
            int port = url.getPort();
            if (port > 0 && port != url.getDefaultPort()) {
                buf.append(':').append(port);
            }
            buf.append(url.getPath());
            return new URI(buf.toString());
        }
        catch (URISyntaxException mue) {
            throw new OAuthSignatureException(mue);
        }
    }

    private static String elements(OAuthRequest request, OAuthParameters params) throws OAuthSignatureException {
        StringBuilder buf = new StringBuilder(request.getRequestMethod().toUpperCase());
        buf.append('&').append(UriComponent.encode((String)OAuthSignature.constructRequestURL(request).toASCIIString(), (UriComponent.Type)UriComponent.Type.UNRESERVED));
        buf.append('&').append(UriComponent.encode((String)OAuthSignature.normalizeParameters(request, params), (UriComponent.Type)UriComponent.Type.UNRESERVED));
        return buf.toString();
    }

    private static OAuthSignatureMethod getSignatureMethod(OAuthParameters params) throws UnsupportedSignatureMethodException {
        OAuthSignatureMethod method = Methods.getInstance(params.getSignatureMethod());
        if (method == null) {
            throw new UnsupportedSignatureMethodException(params.getSignatureMethod());
        }
        return method;
    }

    private static void addParam(String key, String value, List<String[]> list) {
        list.add(new String[]{UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.UNRESERVED), UriComponent.encode((String)value, (UriComponent.Type)UriComponent.Type.UNRESERVED)});
    }
}

