/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.client.apache;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.TerminatingClientHandler;
import com.sun.jersey.client.apache.config.ApacheHttpClientState;
import com.sun.jersey.client.apache.config.DefaultCredentialsProvider;
import com.sun.jersey.core.header.InBoundHeaders;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApacheHttpClientHandler
extends TerminatingClientHandler {
    private static final DefaultCredentialsProvider DEFAULT_CREDENTIALS_PROVIDER = new DefaultCredentialsProvider();
    private final HttpClient client;

    public ApacheHttpClientHandler(HttpClient client) {
        this.client = client;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        Map props = cr.getProperties();
        HttpMethod method = this.getHttpMethod(cr);
        method.setDoAuthentication(true);
        HttpMethodParams methodParams = method.getParams();
        if (!cr.getPropertyAsFeature("com.sun.jersey.impl.client.httpclient.handleCookies")) {
            methodParams.setCookiePolicy("ignoreCookies");
        }
        if (cr.getPropertyAsFeature("com.sun.jersey.impl.client.httpclient.interactive")) {
            CredentialsProvider provider = (CredentialsProvider)props.get("com.sun.jersey.impl.client.httpclient.credentialsProvider");
            if (provider == null) {
                provider = DEFAULT_CREDENTIALS_PROVIDER;
            }
            methodParams.setParameter("http.authentication.credential-provider", (Object)provider);
        } else {
            methodParams.setParameter("http.authentication.credential-provider", null);
        }
        Integer readTimeout = (Integer)props.get("com.sun.jersey.client.property.readTimeout");
        if (readTimeout != null) {
            methodParams.setSoTimeout(readTimeout.intValue());
        }
        this.writeOutBoundHeaders((MultivaluedMap<String, Object>)cr.getMetadata(), method);
        if (method instanceof EntityEnclosingMethod) {
            EntityEnclosingMethod entMethod = (EntityEnclosingMethod)method;
            if (cr.getEntity() != null) {
                Integer chunkedEncodingSize = (Integer)props.get("com.sun.jersey.client.property.chunkedEncodingSize");
                if (chunkedEncodingSize != null) {
                    entMethod.setContentChunked(true);
                } else {
                    entMethod.setContentChunked(false);
                }
                final TerminatingClientHandler.RequestEntityWriter re = this.getRequestEntityWriter(cr);
                entMethod.setRequestEntity(new RequestEntity(){

                    public boolean isRepeatable() {
                        return false;
                    }

                    public void writeRequest(OutputStream out) throws IOException {
                        re.writeRequestEntity(out);
                    }

                    public long getContentLength() {
                        return re.getSize();
                    }

                    public String getContentType() {
                        return re.getMediaType().toString();
                    }
                });
            }
        } else {
            method.setFollowRedirects(cr.getPropertyAsFeature("com.sun.jersey.client.property.followRedirects"));
        }
        try {
            this.client.executeMethod(this.getHostConfiguration(this.client, props), method, this.getHttpState(props));
            return new HttpClientResponse(method);
        }
        catch (Exception e) {
            method.releaseConnection();
            throw new ClientHandlerException((Throwable)e);
        }
    }

    private HttpMethod getHttpMethod(ClientRequest cr) {
        String strMethod = cr.getMethod();
        String uri = cr.getURI().toString();
        if (strMethod.equals("GET")) {
            return new GetMethod(uri);
        }
        if (strMethod.equals("POST")) {
            return new PostMethod(uri);
        }
        if (strMethod.equals("PUT")) {
            return new PutMethod(uri);
        }
        if (strMethod.equals("DELETE")) {
            return new DeleteMethod(uri);
        }
        if (strMethod.equals("HEAD")) {
            return new HeadMethod(uri);
        }
        if (strMethod.equals("OPTIONS")) {
            return new OptionsMethod(uri);
        }
        throw new ClientHandlerException("Method " + strMethod + " is not supported.");
    }

    private HostConfiguration getHostConfiguration(HttpClient client, Map<String, Object> props) {
        Object proxy = props.get("com.sun.jersey.impl.client.httpclient.proxyURI");
        if (proxy != null) {
            int proxyPort;
            URI proxyUri = this.getProxyUri(proxy);
            String proxyHost = proxyUri.getHost();
            if (proxyHost == null) {
                proxyHost = "localhost";
            }
            if ((proxyPort = proxyUri.getPort()) == -1) {
                proxyPort = 8080;
            }
            HostConfiguration hostConfig = new HostConfiguration(client.getHostConfiguration());
            String setHost = hostConfig.getProxyHost();
            int setPort = hostConfig.getProxyPort();
            if (setHost == null || !setHost.equals(proxyHost) || setPort == -1 || setPort != proxyPort) {
                hostConfig.setProxyHost(new ProxyHost(proxyHost, proxyPort));
            }
            return hostConfig;
        }
        return null;
    }

    private HttpState getHttpState(Map<String, Object> props) {
        ApacheHttpClientState httpState = (ApacheHttpClientState)props.get("com.sun.jersey.impl.client.httpclient.httpState");
        if (httpState != null) {
            return httpState.getHttpState();
        }
        return null;
    }

    private URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ClientHandlerException("The proxy URI property MUST be an instance of String or URI");
    }

    private void writeOutBoundHeaders(MultivaluedMap<String, Object> metadata, HttpMethod method) {
        for (Map.Entry e : metadata.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                method.setRequestHeader((String)e.getKey(), this.headerValueToString(vs.get(0)));
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (Object v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(this.headerValueToString(v));
            }
            method.setRequestHeader((String)e.getKey(), b.toString());
        }
    }

    private InBoundHeaders getInBoundHeaders(HttpMethod method) {
        Header[] respHeaders;
        InBoundHeaders headers = new InBoundHeaders();
        for (Header header : respHeaders = method.getResponseHeaders()) {
            ArrayList<String> list = (ArrayList<String>)headers.get((Object)header.getName());
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(header.getValue());
            headers.put((Object)header.getName(), list);
        }
        return headers;
    }

    private final class HttpClientResponse
    extends ClientResponse {
        private final HttpMethod method;

        HttpClientResponse(HttpMethod method) throws IOException {
            super(method.getStatusCode(), ApacheHttpClientHandler.this.getInBoundHeaders(method), (InputStream)new HttpClientResponseInputStream(method), ApacheHttpClientHandler.this.getMessageBodyWorkers());
            this.method = method;
        }

        public boolean hasEntity() {
            if (this.method instanceof HeadMethod) {
                return false;
            }
            Header contentLength = this.method.getResponseHeader("Content-Length");
            if (contentLength != null) {
                try {
                    int len = Integer.parseInt(contentLength.getValue());
                    return len > 0 || len == -1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static final class HttpClientResponseInputStream
    extends FilterInputStream {
        private final HttpMethod method;

        HttpClientResponseInputStream(HttpMethod method) throws IOException {
            super(method.getResponseBodyAsStream());
            this.method = method;
        }

        public void close() throws IOException {
            super.close();
            this.method.releaseConnection();
        }
    }
}

