/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.atom.abdera;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.parser.Parser;

public class ContentHelper {
    private Abdera abdera = Abdera.getInstance();
    private Annotation[] emptyAnnotations = new Annotation[0];
    private MultivaluedMap<String, String> emptyHeaders = new MultivaluedMapImpl();
    private Providers providers;

    public ContentHelper(Providers providers) {
        this.providers = providers;
    }

    public <T> T getContentEntity(Entry entry, Class<T> clazz) {
        String[] parts = entry.getContentMimeType().toString().split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid content type '" + entry.getContentMimeType().toString() + "'");
        }
        return this.getContentEntity(entry, new MediaType(parts[0], parts[1]), clazz);
    }

    public <T> T getContentEntity(Entry entry, MediaType mediaType, Class<T> clazz) {
        MessageBodyReader reader = this.providers.getMessageBodyReader(clazz, clazz, this.emptyAnnotations, mediaType);
        if (reader == null) {
            throw new IllegalArgumentException("No MessageBodyReader for class '" + clazz.getName() + "' and media type '" + mediaType + "'");
        }
        if (entry.getContentElement() == null || entry.getContentElement().getValueElement() == null) {
            throw new IllegalArgumentException("Entry does not contain a valid content element");
        }
        Element element = entry.getContentElement().getValueElement();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            element.writeTo((OutputStream)baos);
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            return (T)reader.readFrom(clazz, clazz, this.emptyAnnotations, mediaType, this.emptyHeaders, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setContentEntity(Entry entry, MediaType mediaType, Object entity) {
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(entity.getClass(), entity.getClass(), this.emptyAnnotations, mediaType);
        if (writer == null) {
            throw new IllegalArgumentException("No MessageBodyWriter for class '" + entity.getClass().getName() + "' and media type '" + mediaType + "'");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            writer.writeTo(entity, entity.getClass(), entity.getClass(), this.emptyAnnotations, mediaType, this.emptyHeaders, (OutputStream)baos);
        }
        catch (IOException e) {
            // empty catch block
        }
        Parser parser = this.abdera.getParser();
        Document document = parser.parse((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        entry.setContent(document.getRoot(), mediaType.toString());
    }
}

