/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart.impl;

import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.MultiPartConfig;
import com.sun.jersey.spi.inject.ClientSide;
import com.sun.jersey.spi.inject.ConstrainedTo;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.jvnet.mimepull.Header;
import org.jvnet.mimepull.MIMEConfig;
import org.jvnet.mimepull.MIMEMessage;
import org.jvnet.mimepull.MIMEParsingException;
import org.jvnet.mimepull.MIMEPart;

@ConstrainedTo(value=ClientSide.class)
@Consumes(value={"multipart/*"})
public class MultiPartReaderClientSide
implements MessageBodyReader<MultiPart> {
    private final Providers providers;
    private final MultiPartConfig config;
    private final MIMEConfig mimeConfig;

    public MultiPartReaderClientSide(@Context Providers providers, @Context MultiPartConfig config) {
        this.providers = providers;
        if (config == null) {
            throw new IllegalArgumentException("The MultiPartConfig instance we expected is not present.  Have you registered the MultiPartConfigProvider class?");
        }
        this.config = config;
        this.mimeConfig = new MIMEConfig();
        this.mimeConfig.setMemoryThreshold((long)config.getBufferThreshold());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    public MultiPart readFrom(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, WebApplicationException {
        try {
            return this.readMultiPart(type, genericType, annotations, mediaType, headers, stream);
        }
        catch (MIMEParsingException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }

    protected MultiPart readMultiPart(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, MIMEParsingException {
        boolean fileNameFix;
        MultiPart multiPart;
        mediaType = MultiPartReaderClientSide.unquoteMediaTypeParameters(mediaType, "boundary");
        MIMEMessage mm = new MIMEMessage(stream, (String)mediaType.getParameters().get("boundary"), this.mimeConfig);
        boolean formData = false;
        if (MediaTypes.typeEquals((MediaType)mediaType, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE)) {
            multiPart = new FormDataMultiPart();
            formData = true;
        } else {
            multiPart = new MultiPart();
        }
        multiPart.setProviders(this.providers);
        MultivaluedMap<String, String> mpHeaders = multiPart.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                mpHeaders.add(entry.getKey(), (Object)value);
            }
        }
        if (!formData) {
            multiPart.setMediaType(mediaType);
            fileNameFix = false;
        } else {
            String userAgent = (String)headers.getFirst((Object)"User-Agent");
            fileNameFix = userAgent != null && userAgent.contains(" MSIE ");
        }
        for (MIMEPart mp : mm.getAttachments()) {
            BodyPart bodyPart = formData ? new FormDataBodyPart(fileNameFix) : new BodyPart();
            bodyPart.setProviders(this.providers);
            for (Header h : mp.getAllHeaders()) {
                bodyPart.getHeaders().add((Object)h.getName(), (Object)h.getValue());
            }
            try {
                String contentType = (String)bodyPart.getHeaders().getFirst((Object)"Content-Type");
                if (contentType != null) {
                    bodyPart.setMediaType(MediaType.valueOf((String)contentType));
                }
                bodyPart.getContentDisposition();
            }
            catch (IllegalArgumentException ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
            }
            bodyPart.setEntity(new BodyPartEntity(mp));
            multiPart.getBodyParts().add(bodyPart);
        }
        return multiPart;
    }

    protected static MediaType unquoteMediaTypeParameters(MediaType mediaType, String ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return mediaType;
        }
        HashMap<String, String> unquotedParams = new HashMap<String, String>(mediaType.getParameters());
        for (String parameterName : parameters) {
            String parameterValue = (String)mediaType.getParameters().get(parameterName);
            if (!parameterValue.startsWith("\"")) continue;
            parameterValue = parameterValue.substring(1, parameterValue.length() - 1);
            unquotedParams.put(parameterName, parameterValue);
        }
        return new MediaType(mediaType.getType(), mediaType.getSubtype(), unquotedParams);
    }
}

