/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.wadl;

import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import com.sun.jersey.server.wadl.ApplicationDescription;
import com.sun.jersey.server.wadl.WadlBuilder;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.server.wadl.generators.WadlGeneratorJAXBGrammarGenerator;
import com.sun.jersey.wadl.AbstractMojoProjectClasspathSupport;
import com.sun.jersey.wadl.WadlGeneratorDescription;
import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Grammars;
import com.sun.research.ws.wadl.Include;
import com.sun.research.ws.wadl.Resources;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;

public class GenerateWadlMojo
extends AbstractMojoProjectClasspathSupport {
    private static final Logger LOG = Logger.getLogger(GenerateWadlMojo.class.getName());
    private File _wadlFile;
    private boolean _formatWadlFile = true;
    private String _baseUri;
    private String[] _packagesResourceConfig;
    private List<WadlGeneratorDescription> _wadlGenerators;

    @Override
    public void executeWithClasspath(List<String> classpathElements) throws MojoExecutionException {
        if (this._packagesResourceConfig == null || this._packagesResourceConfig.length == 0) {
            throw new MojoExecutionException("The packagesResourceConfig attribute is required but not defined.");
        }
        if (this._wadlFile == null) {
            throw new MojoExecutionException("The wadlFile attribute is required but not defined.");
        }
        if (this._baseUri == null || this._baseUri.length() == 0) {
            throw new MojoExecutionException("The baseUri attribute is required but not defined.");
        }
        try {
            WadlGeneratorJAXBGrammarGenerator wadlGenerator = new WadlGeneratorJAXBGrammarGenerator();
            if (this._wadlGenerators != null) {
                for (WadlGeneratorDescription wadlGeneratorDescription : this._wadlGenerators) {
                    wadlGenerator = this.loadWadlGenerator(wadlGeneratorDescription, (WadlGenerator)wadlGenerator);
                }
            }
            wadlGenerator.init();
            ApplicationDescription ad = this.createApplicationDescription(this._packagesResourceConfig, (WadlGenerator)wadlGenerator);
            Application a = ad.getApplication();
            for (Resources resources : a.getResources()) {
                resources.setBase(this._baseUri);
            }
            this.writeExternalGrammars(ad);
            JAXBContext c = JAXBContext.newInstance((String)wadlGenerator.getRequiredJaxbContextPath(), (ClassLoader)Thread.currentThread().getContextClassLoader());
            Marshaller m = c.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)this._formatWadlFile);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this._wadlFile));
            XMLSerializer serializer = this.getXMLSerializer(out);
            m.marshal((Object)a, (ContentHandler)serializer);
            ((OutputStream)out).close();
            this.getLog().info((CharSequence)("Wrote " + this._wadlFile));
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Could not write wadl file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExternalGrammars(ApplicationDescription ad) throws FileNotFoundException, IOException {
        Grammars grammars;
        File wadlParent = this._wadlFile.getParentFile();
        Set externalMetadataKeys = ad.getExternalMetadataKeys();
        if (ad.getApplication().getGrammars() != null) {
            LOG.info("The wadl application already contains a grammars element, we're adding elements of the provided grammars file.");
            grammars = ad.getApplication().getGrammars();
        } else {
            grammars = new Grammars();
            ad.getApplication().setGrammars(grammars);
        }
        for (String path : externalMetadataKeys) {
            ApplicationDescription.ExternalGrammar externalGrammar = ad.getExternalGrammar(path);
            File externalFile = new File(wadlParent, path);
            BufferedOutputStream externalGrammarOutputStream = new BufferedOutputStream(new FileOutputStream(externalFile));
            try {
                ((OutputStream)externalGrammarOutputStream).write(externalGrammar.getContent());
                this.getLog().info((CharSequence)("Wrote " + externalFile));
            }
            finally {
                ((OutputStream)externalGrammarOutputStream).close();
            }
            Include include = new Include();
            include.setHref(path);
            Doc doc = new Doc();
            include.getDoc().add(doc);
            grammars.getInclude().add(include);
        }
    }

    private XMLSerializer getXMLSerializer(OutputStream out) throws FileNotFoundException {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(new String[]{"http://wadl.dev.java.net/2009/02^doc", "ns2^doc", "^doc"});
        of.setPreserveSpace(true);
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(out);
        return serializer;
    }

    private WadlGenerator loadWadlGenerator(WadlGeneratorDescription wadlGeneratorDescription, WadlGenerator wadlGeneratorDelegate) throws Exception {
        this.getLog().info((CharSequence)("Loading wadlGenerator " + wadlGeneratorDescription.getClassName()));
        Class<?> clazz = Class.forName(wadlGeneratorDescription.getClassName(), true, Thread.currentThread().getContextClassLoader());
        WadlGenerator generator = clazz.asSubclass(WadlGenerator.class).newInstance();
        generator.setWadlGeneratorDelegate(wadlGeneratorDelegate);
        if (wadlGeneratorDescription.getProperties() != null && !wadlGeneratorDescription.getProperties().isEmpty()) {
            for (Map.Entry<Object, Object> entry : wadlGeneratorDescription.getProperties().entrySet()) {
                this.setProperty(generator, entry.getKey().toString(), entry.getValue());
            }
        }
        return generator;
    }

    private void setProperty(Object object, String propertyName, Object propertyValue) throws Exception {
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method method = this.getMethodByName(methodName, object.getClass());
        if (method.getParameterTypes().length != 1) {
            throw new RuntimeException("Method " + methodName + " is no setter, it does not expect exactly one parameter, but " + method.getParameterTypes().length);
        }
        Class<?> paramClazz = method.getParameterTypes()[0];
        if (paramClazz == propertyValue.getClass()) {
            method.invoke(object, propertyValue);
        } else {
            Constructor<?> paramTypeConstructor = this.getMatchingConstructor(paramClazz, propertyValue);
            if (paramTypeConstructor != null) {
                Object typedPropertyValue;
                try {
                    typedPropertyValue = paramTypeConstructor.newInstance(propertyValue);
                }
                catch (Exception e) {
                    throw new Exception("Could not create instance of configured property " + propertyName + " from value " + propertyValue + ", using the constructor " + paramTypeConstructor, e);
                }
                method.invoke(object, typedPropertyValue);
            } else {
                throw new RuntimeException("The property '" + propertyName + "' could not be set" + " because the expected parameter is neither of type " + propertyValue.getClass() + " nor of any type that provides a constructor expecting a " + propertyValue.getClass() + "." + " The expected parameter is of type " + paramClazz.getName());
            }
        }
    }

    private Constructor<?> getMatchingConstructor(Class<?> paramClazz, Object propertyValue) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = paramClazz.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || constructor.getParameterTypes()[0] != propertyValue.getClass()) continue;
            return constructor;
        }
        return null;
    }

    private Method getMethodByName(String methodName, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new RuntimeException("Method '" + methodName + "' not found for class " + clazz.getName());
    }

    private ApplicationDescription createApplicationDescription(String[] paths, WadlGenerator wadlGenerator) throws MojoExecutionException {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("com.sun.jersey.config.property.packages", paths);
        PackagesResourceConfig rc = new PackagesResourceConfig(map);
        HashSet<AbstractResource> s = new HashSet<AbstractResource>();
        for (Class c : rc.getRootResourceClasses()) {
            this.getLog().debug((CharSequence)("Adding class " + c.getName()));
            s.add(IntrospectionModeller.createResource((Class)c));
        }
        return new WadlBuilder(wadlGenerator).generate(null, null, null, s);
    }

    public void setWadlFile(File wadlFile) {
        this._wadlFile = wadlFile;
    }

    public void setBaseUri(String baseUri) {
        this._baseUri = baseUri;
    }

    public void setPackagesResourceConfig(String[] packagesResourceConfig) {
        this._packagesResourceConfig = packagesResourceConfig;
    }

    public void setFormatWadlFile(boolean formatWadlFile) {
        this._formatWadlFile = formatWadlFile;
    }

    public void setWadlGenerators(List<WadlGeneratorDescription> wadlGenerators) {
        this._wadlGenerators = wadlGenerators;
    }

    private static class JAXBGrammars
    extends Grammars {
        public JAXBGrammars(List<String> hrefs) {
            ArrayList<Include> includes = new ArrayList<Include>();
            for (String href : hrefs) {
                Include include = new Include();
                include.setHref(href);
                includes.add(include);
            }
            this.include = includes;
        }
    }
}

