/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.test.framework.TestConstants;
import com.sun.jersey.test.framework.impl.JerseyAppContainer;
import com.sun.jersey.test.framework.impl.util.CommonUtils;
import com.sun.jersey.test.framework.util.ApplicationDescriptor;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Before;

public abstract class JerseyTest
implements TestConstants {
    protected final String CONTAINER_TYPE = this.getContainerType();
    protected Map<String, String> INIT_PARAMS = new HashMap<String, String>();
    protected Map<String, String> CONTEXT_PARAMS = new HashMap<String, String>();
    protected URI BASE_URI;
    protected String contextPath;
    protected String servletPath;
    private Class servletClass;
    private String contextListenerClassName;
    protected String resourcePackage;
    protected JerseyAppContainer container;
    protected WebResource webResource;
    protected Client jerseyClient;

    public JerseyTest() throws Exception {
    }

    public JerseyTest(String resourcePackageName) throws Exception {
        ApplicationDescriptor appDescriptor = new ApplicationDescriptor().setRootResourcePackageName(resourcePackageName);
        this.setupTestEnvironment(appDescriptor);
    }

    public JerseyTest(String contextPath, String servletPath, String resourcePackageName) throws Exception {
        ApplicationDescriptor appDescriptor = new ApplicationDescriptor().setRootResourcePackageName(resourcePackageName).setContextPath(contextPath).setServletPath(servletPath);
        this.setupTestEnvironment(appDescriptor);
    }

    @Before
    public void setUp() throws Exception {
        boolean setLogging = System.getProperty("enableLogging") != null;
        this.jerseyClient = Client.create();
        if (setLogging) {
            this.jerseyClient.addFilter((ClientFilter)new LoggingFilter());
        }
        this.webResource = this.jerseyClient.resource(this.BASE_URI);
    }

    @After
    public void tearDown() throws Exception {
        this.container.stopServer();
    }

    protected String getContainerType() {
        String containerType = System.getProperty("container.type");
        return containerType != null ? containerType : "GrizzlyWeb";
    }

    protected void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    protected void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    protected void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public void setupTestEnvironment(ApplicationDescriptor appDescriptor) throws Exception {
        this.setContextPath(appDescriptor.getContextPath());
        this.setServletPath(appDescriptor.getServletPath());
        this.setResourcePackage(appDescriptor.getRootResourcePackageName());
        this.BASE_URI = CommonUtils.getBaseURI(this.contextPath, this.servletPath);
        this.INIT_PARAMS.put("com.sun.jersey.config.property.packages", this.resourcePackage);
        if (appDescriptor.getContextParams() != null) {
            this.CONTEXT_PARAMS.putAll(appDescriptor.getContextParams());
        }
        this.servletClass = appDescriptor.getServletClass();
        this.contextListenerClassName = appDescriptor.getContextListenerClassName();
        this.container = new JerseyAppContainer(this.CONTAINER_TYPE, appDescriptor);
        this.container.startServer();
    }
}

