/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.impl;

import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.test.framework.TestConstants;
import com.sun.jersey.test.framework.impl.BasicLightWeightContainer;
import com.sun.jersey.test.framework.impl.BasicServletContainer;
import com.sun.jersey.test.framework.impl.Deployable;
import com.sun.jersey.test.framework.impl.container.embedded.glassfish.EmbeddedGlassfish;
import com.sun.jersey.test.framework.impl.container.grizzly.web.GrizzlyWebContainer;
import com.sun.jersey.test.framework.impl.container.http.HTTPContainer;
import com.sun.jersey.test.framework.impl.util.CommonUtils;
import com.sun.jersey.test.framework.impl.util.WebXmlGenerator;
import com.sun.jersey.test.framework.util.ApplicationDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JerseyAppContainer
implements TestConstants {
    private String containerType;
    private URI baseUri;
    private String servletPath;
    private String contextPath;
    private Map<String, String> initParams;
    private Map<String, String> contextParams;
    private String contextListenerClassName;
    private Class servletClass;
    private Hashtable<String, Class> containerTable = new Hashtable();
    private BasicLightWeightContainer container;
    private ApplicationDescriptor appDescriptor;
    private String webXml = "web.xml";
    private String webXmlDirPath = "target/webapp/WEB-INF";
    private static final Logger logger = Logger.getLogger(JerseyAppContainer.class.getName());

    public JerseyAppContainer(String containerType, ApplicationDescriptor applicationDescriptor) {
        this.containerTable.put("EmbeddedGF", EmbeddedGlassfish.class);
        this.containerTable.put("GrizzlyWeb", GrizzlyWebContainer.class);
        this.containerTable.put("HTTPServer", HTTPContainer.class);
        if (!this.containerTable.containsKey(containerType)) {
            logger.log(Level.SEVERE, "Invalid container.type attribute passed. Expected one of :: ");
            logger.log(Level.SEVERE, "====================");
            logger.log(Level.SEVERE, "EmbeddedGF\nGrizzlyWeb\nHTTPServer");
            logger.log(Level.SEVERE, "====================");
            System.exit(-1);
        }
        this.containerType = containerType;
        this.appDescriptor = applicationDescriptor;
        this.readApplicationDescriptor();
    }

    public void startServer() throws Exception {
        this.container = (BasicLightWeightContainer)this.containerTable.get(this.containerType).newInstance();
        this.container.setBaseUri(this.baseUri);
        this.container.setInitParams(this.initParams);
        if (this.container instanceof BasicServletContainer) {
            ((BasicServletContainer)this.container).setContextParams(this.contextParams);
            ((BasicServletContainer)this.container).setServletClass(this.servletClass);
            ((BasicServletContainer)this.container).setServletListener(this.contextListenerClassName);
            ((BasicServletContainer)this.container).setServletPath(this.servletPath);
            ((BasicServletContainer)this.container).setContextPath(this.contextPath);
        } else if (this.contextParams != null && this.contextParams.size() > 0) {
            logger.log(Level.SEVERE, "The test cannot be run on " + this.containerType + " since there " + "is no way to pass context params to the server instance.");
            System.exit(-1);
        }
        if (this.container instanceof Deployable) {
            File webXmlDir = new File(this.webXmlDirPath);
            webXmlDir.mkdirs();
            File file = new File(this.webXmlDirPath + "/" + this.webXml);
            if (file.createNewFile()) {
                FileOutputStream outputStream = new FileOutputStream(file);
                WebXmlGenerator webXmlGenerator = new WebXmlGenerator(this.appDescriptor);
                webXmlGenerator.marshalData(outputStream);
                ((OutputStream)outputStream).close();
            }
        }
        this.container.start();
    }

    public void stopServer() throws Exception {
        this.container.stop();
    }

    private void readApplicationDescriptor() {
        this.initParams = new HashMap<String, String>();
        this.initParams.put("com.sun.jersey.config.property.resourceConfigClass", PackagesResourceConfig.class.getName());
        this.initParams.put("com.sun.jersey.config.property.packages", this.appDescriptor.getRootResourcePackageName());
        if (this.appDescriptor.getServletInitParams() != null) {
            this.initParams.putAll(this.appDescriptor.getServletInitParams());
        } else {
            this.appDescriptor.setServletInitParams(this.initParams);
        }
        this.contextParams = this.appDescriptor.getContextParams();
        this.servletClass = this.appDescriptor.getServletClass();
        this.contextListenerClassName = this.appDescriptor.getContextListenerClassName();
        this.servletPath = this.appDescriptor.getServletPath();
        this.contextPath = this.appDescriptor.getContextPath();
        this.baseUri = CommonUtils.getBaseURI(this.contextPath, this.servletPath);
    }
}

