/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.impl.container.grizzly;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.tcp.Adapter;
import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.api.container.grizzly.GrizzlyServerFactory;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.test.framework.impl.BasicLightWeightContainer;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyContainer
implements BasicLightWeightContainer {
    private Map<String, String> initParams = new HashMap<String, String>();
    private SelectorThread selectorThread;
    private URI BASE_URI;
    private static final Logger logger = Logger.getLogger(GrizzlyContainer.class.getName());

    @Override
    public void start() throws Exception {
        logger.log(Level.INFO, "Starting grizzly...");
        String resources = this.initParams.get("com.sun.jersey.config.property.packages");
        logger.log(Level.INFO, "Resources package :: " + resources);
        PackagesResourceConfig resourceConfig = new PackagesResourceConfig(new String[]{resources});
        Adapter adapter = (Adapter)ContainerFactory.createContainer(Adapter.class, (ResourceConfig)resourceConfig);
        try {
            this.selectorThread = GrizzlyServerFactory.create((URI)this.BASE_URI, (ResourceConfig)resourceConfig);
            GrizzlyContainer grizzlyContainer = this;
            logger.log(Level.INFO, "App root path :: " + grizzlyContainer.selectorThread.getWebAppRootPath());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        logger.log(Level.INFO, "Started GrizzlyServer");
    }

    @Override
    public void stop() throws Exception {
        if (this.selectorThread.isRunning()) {
            this.selectorThread.stopEndpoint();
        }
    }

    @Override
    public void setBaseUri(URI baseUri) {
        this.BASE_URI = baseUri;
    }

    @Override
    public void setInitParams(Map<String, String> initParams) {
        this.initParams.putAll(initParams);
    }

    @Override
    public void setHttpListenerPort(int httpPort) {
    }
}

