/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.impl.container.grizzly.web;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.test.framework.impl.BasicServletContainer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyWebContainer
implements BasicServletContainer {
    private Map<String, String> initParams = new HashMap<String, String>();
    private Map<String, String> contextParams = new HashMap<String, String>();
    private Class servletClass;
    private String contextListenerClassName;
    private String servletPath;
    private String contextPath;
    private SelectorThread threadSelector;
    private URI BASE_URI;
    private GrizzlyWebServer ws;
    private static final Logger logger = Logger.getLogger(GrizzlyWebContainer.class.getName());
    private static int index = 0;

    @Override
    public void start() throws Exception {
        logger.log(Level.INFO, "Starting grizzly...");
        this.ws = new GrizzlyWebServer(this.BASE_URI.getPort());
        ServletAdapter sa = new ServletAdapter();
        sa.setRootFolder("." + ++index);
        Servlet servletInstance = (Servlet)this.servletClass.newInstance();
        sa.setServletInstance(servletInstance);
        sa.addServletListener(this.contextListenerClassName);
        for (String contextParamName : this.contextParams.keySet()) {
            sa.addContextParameter(contextParamName, this.contextParams.get(contextParamName));
        }
        for (String initParamName : this.initParams.keySet()) {
            sa.addInitParameter(initParamName, this.initParams.get(initParamName));
        }
        if (this.contextPath != null && this.contextPath.length() > 0) {
            if (!this.contextPath.startsWith("/")) {
                this.contextPath = "/" + this.contextPath;
            }
            sa.setContextPath(this.contextPath);
        }
        if (this.servletPath != null && this.servletPath.length() > 0) {
            if (!this.servletPath.startsWith("/")) {
                this.servletPath = "/" + this.servletPath;
            }
            sa.setServletPath(this.servletPath);
        }
        String[] mapping = null;
        this.ws.addGrizzlyAdapter((GrizzlyAdapter)sa, mapping);
        this.ws.start();
    }

    @Override
    public void stop() throws Exception {
        this.ws.stop();
    }

    @Override
    public void setBaseUri(URI baseUri) {
        this.BASE_URI = baseUri;
    }

    @Override
    public void setInitParams(Map<String, String> initParams) {
        this.initParams.putAll(initParams);
    }

    @Override
    public void setHttpListenerPort(int httpPort) {
    }

    @Override
    public void setContextParams(Map<String, String> contextParams) {
        if (contextParams != null) {
            this.contextParams.putAll(contextParams);
        }
    }

    @Override
    public void setServletClass(Class servletClass) {
        this.servletClass = servletClass != null ? servletClass : ServletContainer.class;
    }

    @Override
    public void setServletListener(String servletListenerClass) {
        if (servletListenerClass != null && servletListenerClass.length() > 0) {
            this.contextListenerClassName = servletListenerClass;
        }
    }

    @Override
    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }
}

