/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.comm;

import com.sun.btrace.comm.DataCommand;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MessageCommand
extends DataCommand {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss:SSS");
    private long time;
    private String msg;

    public MessageCommand(long time, String msg) {
        super((byte)4, null);
        this.time = time;
        this.msg = msg;
    }

    public MessageCommand(String msg) {
        this(0L, msg);
    }

    protected MessageCommand() {
        this(0L, null);
    }

    @Override
    protected void write(ObjectOutput out) throws IOException {
        out.writeLong(this.time);
        out.writeUTF(this.msg != null ? this.msg : "");
    }

    @Override
    protected void read(ObjectInput in) throws ClassNotFoundException, IOException {
        this.time = in.readLong();
        this.msg = in.readUTF();
    }

    public long getTime() {
        return this.time;
    }

    public String getMessage() {
        return this.msg;
    }

    @Override
    public void print(PrintWriter out) {
        if (this.time != 0L) {
            out.print(DATE_FORMAT.format(new Date(this.time)));
            out.print(" : ");
        }
        if (this.msg != null) {
            out.print(this.msg);
        }
    }
}

