/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.compiler;

import com.sun.btrace.compiler.MemoryJavaFileManager;
import com.sun.btrace.compiler.Postprocessor;
import com.sun.btrace.compiler.Verifier;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.util.Messages;
import com.sun.source.util.JavacTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class Compiler {
    private JavaCompiler compiler;
    private StandardJavaFileManager stdManager;
    public List<String> includeDirs;
    private boolean unsafe;

    public Compiler(String includePath, boolean unsafe) {
        if (includePath != null) {
            String[] paths;
            this.includeDirs = new ArrayList<String>();
            for (String p : paths = includePath.split(File.pathSeparator)) {
                this.includeDirs.add(p);
            }
        }
        this.unsafe = unsafe;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.stdManager = this.compiler.getStandardFileManager(null, null, null);
    }

    public Compiler() {
        this(null, false);
    }

    private static void usage(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private static void usage() {
        Compiler.usage(Messages.get("btracec.usage"));
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Compiler.usage();
        }
        String classPath = ".";
        String outputDir = ".";
        String includePath = null;
        boolean unsafe = false;
        int count = 0;
        boolean classPathDefined = false;
        boolean outputDirDefined = false;
        boolean includePathDefined = false;
        boolean unsafeDefined = false;
        while (args[count].charAt(0) == '-') {
            if (args.length <= count + 1) {
                Compiler.usage();
            }
            if ((args[count].equals("-cp") || args[count].equals("-classpath")) && !classPathDefined) {
                classPath = args[++count];
                classPathDefined = true;
            } else if (args[count].equals("-d") && !outputDirDefined) {
                outputDir = args[++count];
                outputDirDefined = true;
            } else if (args[count].equals("-I") && !includePathDefined) {
                includePath = args[++count];
                includePathDefined = true;
            } else if (args[count].equals("-unsafe") && !unsafeDefined) {
                unsafe = true;
                unsafeDefined = true;
            } else {
                Compiler.usage();
            }
            if (++count < args.length) continue;
        }
        if (args.length <= count) {
            Compiler.usage();
        }
        File[] files = new File[args.length - count];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(args[i + count]);
            if (files[i].exists()) continue;
            Compiler.usage("File not found: " + files[i]);
        }
        Compiler compiler = new Compiler(includePath, unsafe);
        Map<String, byte[]> classes = compiler.compile(files, (Writer)new PrintWriter(System.err), ".", classPath = classPath + File.pathSeparator + System.getProperty("java.class.path"));
        if (classes != null) {
            for (Map.Entry<String, byte[]> c : classes.entrySet()) {
                String name = c.getKey().replace(".", File.separator);
                int index = name.lastIndexOf(File.separatorChar);
                String dir = outputDir + File.separator;
                if (index != -1) {
                    dir = dir + name.substring(0, index);
                }
                new File(dir).mkdirs();
                String file = index != -1 ? name.substring(index + 1) : name;
                file = file + ".class";
                File out = new File(dir, file);
                FileOutputStream fos = new FileOutputStream(out);
                fos.write(c.getValue());
                fos.close();
            }
        }
    }

    public Map<String, byte[]> compile(String fileName, String source, Writer err, String sourcePath, String classPath) {
        MemoryJavaFileManager manager = new MemoryJavaFileManager(this.stdManager, this.includeDirs);
        ArrayList<JavaFileObject> compUnits = new ArrayList<JavaFileObject>(1);
        compUnits.add(MemoryJavaFileManager.makeStringSource(fileName, source, this.includeDirs));
        return this.compile(manager, compUnits, err, sourcePath, classPath);
    }

    public Map<String, byte[]> compile(File file, Writer err, String sourcePath, String classPath) {
        File[] files = new File[]{file};
        return this.compile(files, err, sourcePath, classPath);
    }

    public Map<String, byte[]> compile(File[] files, Writer err, String sourcePath, String classPath) {
        Iterable<? extends JavaFileObject> compUnits = this.stdManager.getJavaFileObjects(files);
        ArrayList<JavaFileObject> preprocessedCompUnits = new ArrayList<JavaFileObject>();
        try {
            for (JavaFileObject javaFileObject : compUnits) {
                preprocessedCompUnits.add(MemoryJavaFileManager.preprocessedFileObject(javaFileObject, this.includeDirs));
            }
        }
        catch (IOException ioExp) {
            throw new RuntimeException(ioExp);
        }
        return this.compile(preprocessedCompUnits, err, sourcePath, classPath);
    }

    public Map<String, byte[]> compile(Iterable<? extends JavaFileObject> compUnits, Writer err, String sourcePath, String classPath) {
        MemoryJavaFileManager manager = new MemoryJavaFileManager(this.stdManager, this.includeDirs);
        return this.compile(manager, compUnits, err, sourcePath, classPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, byte[]> compile(MemoryJavaFileManager manager, Iterable<? extends JavaFileObject> compUnits, Writer err, String sourcePath, String classPath) {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> options = new ArrayList<String>();
        options.add("-Xlint:all");
        options.add("-g:lines");
        options.add("-deprecation");
        options.add("-source");
        options.add("1.6");
        options.add("-target");
        options.add("1.6");
        if (sourcePath != null) {
            options.add("-sourcepath");
            options.add(sourcePath);
        }
        if (classPath != null) {
            options.add("-classpath");
            options.add(classPath);
        }
        JavacTask task = (JavacTask)this.compiler.getTask(err, manager, diagnostics, options, null, compUnits);
        Verifier btraceVerifier = new Verifier(this.unsafe);
        task.setTaskListener(btraceVerifier);
        ArrayList<Verifier> processors = new ArrayList<Verifier>(1);
        processors.add(btraceVerifier);
        task.setProcessors(processors);
        PrintWriter perr = err instanceof PrintWriter ? (PrintWriter)err : new PrintWriter(err);
        if (!task.call().booleanValue()) {
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                perr.println(diagnostic.getMessage(null));
            }
            perr.flush();
            return null;
        }
        try {
            Map<String, byte[]> classBytes = manager.getClassBytes();
            List<String> classNames = btraceVerifier.getClassNames();
            HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            for (String name : classNames) {
                if (!classBytes.containsKey(name)) continue;
                this.dump(name + "_before", classBytes.get(name));
                ClassReader cr = new ClassReader(classBytes.get(name));
                ClassWriter cw = new ClassWriter(2);
                cr.accept(new Postprocessor(cw), 10);
                result.put(name, cw.toByteArray());
                this.dump(name + "_after", cw.toByteArray());
            }
            HashMap<String, byte[]> hashMap = result;
            return hashMap;
        }
        finally {
            try {
                manager.close();
            }
            catch (IOException exp) {}
        }
    }

    private void dump(String name, byte[] code) {
    }
}

