/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.util;

import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.MethodInstrumentor;
import com.sun.btrace.util.LocalVariablesSorter;
import com.sun.btrace.util.TimeStampHelper;

public class TimeStampGenerator
extends MethodVisitor {
    public static final String TIME_STAMP_NAME = "$btrace$time$stamp";
    private static final String CONSTRUCTOR = "<init>";
    private int[] tsIndex;
    private int[] exitOpcodes;
    private boolean generatingIndex = false;
    private boolean entryCalled = false;
    private String methodName;
    private String className;
    private String superName;
    private final LocalVariablesSorter lvs;

    public TimeStampGenerator(LocalVariablesSorter lvs, int[] tsIndex, String className, String superName, int access, String name, String desc, MethodVisitor mv, int[] exitOpcodes) {
        super(262144, mv);
        this.lvs = lvs;
        this.methodName = name;
        this.className = className;
        this.superName = superName;
        this.tsIndex = tsIndex;
        this.exitOpcodes = new int[exitOpcodes.length];
        System.arraycopy(exitOpcodes, 0, this.exitOpcodes, 0, exitOpcodes.length);
    }

    @Override
    public void visitCode() {
        this.entryCalled = false;
        if (!CONSTRUCTOR.equals(this.methodName)) {
            this.generateTS(0);
        }
        super.visitCode();
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.tsIndex[1] == -1) {
            for (int exitOpcode : this.exitOpcodes) {
                if (exitOpcode != opcode) continue;
                if (this.tsIndex[0] == -1 || this.tsIndex[1] != -1) break;
                this.generateTS(1);
                break;
            }
        }
        super.visitInsn(opcode);
        if (this.tsIndex[1] != -1) {
            switch (opcode) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    this.tsIndex[1] = -1;
                }
            }
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.generatingIndex) {
            super.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        super.visitMethodInsn(opcode, owner, name, desc);
        if (!this.entryCalled && CONSTRUCTOR.equals(name) && (owner.equals(this.className) || this.superName != null && owner.equals(this.superName))) {
            this.entryCalled = true;
            this.generateTS(0);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTS(int index) {
        if (this.tsIndex != null && this.tsIndex[index] != -1) {
            return;
        }
        if (!((MethodInstrumentor)this.mv).usesTimeStamp()) {
            return;
        }
        if (this.tsIndex[index] > -1) {
            return;
        }
        try {
            this.generatingIndex = true;
            TimeStampHelper.generateTimeStampAccess(this, this.className);
            this.tsIndex[index] = this.lvs.newLocal(Type.LONG_TYPE);
        }
        finally {
            this.generatingIndex = false;
        }
    }
}

