/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class DefaultAuthenticator
extends Authenticator {
    private static final Logger LOGGER = Logger.getLogger(DefaultAuthenticator.class.getName());
    private static DefaultAuthenticator instance;
    private static Authenticator systemAuthenticator;
    private String proxyUser;
    private String proxyPasswd;
    private final List<AuthInfo> authInfo = new ArrayList<AuthInfo>();
    private static int counter;

    DefaultAuthenticator() {
        this.proxyUser = System.getProperty("http.proxyUser") != null ? System.getProperty("http.proxyUser") : System.getProperty("proxyUser");
        this.proxyPasswd = System.getProperty("http.proxyPassword") != null ? System.getProperty("http.proxyPassword") : System.getProperty("proxyPassword");
    }

    public static synchronized DefaultAuthenticator getAuthenticator() {
        if (instance == null) {
            instance = new DefaultAuthenticator();
            Authenticator.setDefault(instance);
        }
        ++counter;
        return instance;
    }

    public static synchronized void reset() {
        if (instance != null && --counter == 0) {
            Authenticator.setDefault(systemAuthenticator);
        }
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.proxyUser != null && this.proxyPasswd != null) {
            return new PasswordAuthentication(this.proxyUser, this.proxyPasswd.toCharArray());
        }
        for (AuthInfo auth : this.authInfo) {
            if (!auth.matchingHost(this.getRequestingURL())) continue;
            return new PasswordAuthentication(auth.getUser(), auth.getPassword().toCharArray());
        }
        return null;
    }

    public void setProxyAuth(String proxyAuth) {
        if (proxyAuth == null) {
            this.proxyUser = null;
            this.proxyPasswd = null;
        } else {
            int i = proxyAuth.indexOf(58);
            if (i < 0) {
                this.proxyUser = proxyAuth;
                this.proxyPasswd = "";
            } else if (i == 0) {
                this.proxyUser = "";
                this.proxyPasswd = proxyAuth.substring(1);
            } else {
                this.proxyUser = proxyAuth.substring(0, i);
                this.proxyPasswd = proxyAuth.substring(i + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuth(File f, Receiver l) {
        Receiver listener = l == null ? new DefaultRImpl() : l;
        BufferedReader in = null;
        FileInputStream fi = null;
        InputStreamReader is = null;
        try {
            LocatorImpl locator = new LocatorImpl();
            locator.setSystemId(f.getAbsolutePath());
            try {
                fi = new FileInputStream(f);
                is = new InputStreamReader((InputStream)fi, "UTF-8");
                in = new BufferedReader(is);
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                listener.onError(e, locator);
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (fi != null) {
                        fi.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
                return;
            }
            try {
                String text;
                int lineno = 1;
                locator.setSystemId(f.getCanonicalPath());
                while ((text = in.readLine()) != null) {
                    locator.setLineNumber(lineno++);
                    if ("".equals(text.trim()) || text.startsWith("#")) continue;
                    try {
                        AuthInfo ai = this.parseLine(text);
                        this.authInfo.add(ai);
                    }
                    catch (Exception e) {
                        listener.onParsingError(text, locator);
                    }
                }
            }
            catch (IOException e) {
                listener.onError(e, locator);
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (is != null) {
                    is.close();
                }
                if (fi != null) {
                    fi.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    private AuthInfo parseLine(String text) throws Exception {
        int i;
        URL url;
        try {
            url = new URL(text);
        }
        catch (MalformedURLException mue) {
            i = text.indexOf(58, text.indexOf(58) + 1) + 1;
            int j = text.lastIndexOf(64);
            String encodedUrl = text.substring(0, i) + URLEncoder.encode(text.substring(i, j), "UTF-8") + text.substring(j);
            url = new URL(encodedUrl);
        }
        String authinfo = url.getUserInfo();
        if (authinfo != null && (i = authinfo.indexOf(58)) >= 0) {
            String user = authinfo.substring(0, i);
            String password = authinfo.substring(i + 1);
            return new AuthInfo(new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile()), user, URLDecoder.decode(password, "UTF-8"));
        }
        throw new Exception();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Authenticator getCurrentAuthenticator() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Authenticator>(){

                @Override
                public Authenticator run() throws Exception {
                    Method method = Authenticator.class.getMethod("getDefault", new Class[0]);
                    return (Authenticator)method.invoke(null, new Object[0]);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Object ex;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, null, pae);
            }
            if (!((ex = pae.getException()) instanceof NoSuchMethodException)) {
                return null;
            }
            final Field f = DefaultAuthenticator.getTheAuthenticator();
            if (f == null) {
                return null;
            }
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        f.setAccessible(true);
                        return null;
                    }
                });
                ex = (Authenticator)f.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException ex2) {
                Authenticator authenticator;
                try {
                    authenticator = null;
                }
                catch (Throwable throwable) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(f){
                        final /* synthetic */ Field val$f;
                        {
                            this.val$f = field;
                        }

                        @Override
                        public Void run() {
                            this.val$f.setAccessible(false);
                            return null;
                        }
                    });
                    throw throwable;
                }
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                return authenticator;
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            return ex;
        }
    }

    private static Field getTheAuthenticator() {
        try {
            return Authenticator.class.getDeclaredField("theAuthenticator");
        }
        catch (NoSuchFieldException | SecurityException ex) {
            return null;
        }
    }

    static {
        systemAuthenticator = DefaultAuthenticator.getCurrentAuthenticator();
        counter = 0;
    }

    static final class AuthInfo {
        private final String user;
        private final String password;
        private final Pattern urlPattern;

        public AuthInfo(URL url, String user, String password) {
            String u = url.toExternalForm().replaceFirst("\\?", "\\\\?");
            this.urlPattern = Pattern.compile(u.replace("*", ".*"), 2);
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean matchingHost(URL requestingURL) {
            return this.urlPattern.matcher(requestingURL.toExternalForm()).matches();
        }
    }

    private static class DefaultRImpl
    implements Receiver {
        private DefaultRImpl() {
        }

        @Override
        public void onParsingError(String line, Locator loc) {
            System.err.println(this.getLocationString(loc) + ": " + line);
        }

        @Override
        public void onError(Exception e, Locator loc) {
            System.err.println(this.getLocationString(loc) + ": " + e.getMessage());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }

        private String getLocationString(Locator l) {
            return "[" + l.getSystemId() + "#" + l.getLineNumber() + "]";
        }
    }

    public static interface Receiver {
        public void onParsingError(String var1, Locator var2);

        public void onError(Exception var1, Locator var2);
    }
}

