/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.local;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.local.LocalTransportFactory;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InVmServer {
    private final List<WSEndpoint> endpoints;
    private final String id;
    private static final Map<String, WeakReference<InVmServer>> servers = new HashMap<String, WeakReference<InVmServer>>();
    private static int iotaGen = 0;

    public InVmServer(@NotNull String id, File explodedWarDir) throws IOException {
        this(id, LocalTransportFactory.parseEndpoints(explodedWarDir.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InVmServer(@NotNull String id, List<WSEndpoint> endpoints) throws IOException {
        Map<String, WeakReference<InVmServer>> map = servers;
        synchronized (map) {
            if (servers.containsKey(id)) {
                throw new IllegalArgumentException("InVmServer with id=" + id + " is already running");
            }
            servers.put(id, new WeakReference<InVmServer>(this));
        }
        this.id = id;
        this.endpoints = new ArrayList<WSEndpoint>(endpoints);
    }

    public InVmServer(File explodedWarDir) throws IOException {
        this(InVmServer.generateId(), explodedWarDir);
    }

    @Nullable
    WSEndpoint getByPortName(String portLocalName) {
        for (WSEndpoint ep : this.endpoints) {
            if (!ep.getPortName().getLocalPart().equals(portLocalName)) continue;
            return ep;
        }
        return null;
    }

    List<WSEndpoint> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    URI getAddress() {
        return URI.create("in-vm://" + this.id + "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        for (WSEndpoint ep : this.endpoints) {
            ep.dispose();
        }
        this.endpoints.clear();
        Map<String, WeakReference<InVmServer>> map = servers;
        synchronized (map) {
            if (servers.get(this.id).get() == this) {
                servers.remove(this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static InVmServer get(String id) {
        Map<String, WeakReference<InVmServer>> map = servers;
        synchronized (map) {
            WeakReference<InVmServer> r = servers.get(id);
            if (r == null) {
                return null;
            }
            if (r.get() == null) {
                servers.remove(id);
                return null;
            }
            return (InVmServer)r.get();
        }
    }

    public String toString() {
        return "InVmServer:" + this.id;
    }

    private static synchronized String generateId() {
        return String.valueOf(iotaGen++);
    }
}

