/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.message;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jvnet.ws.message.MessageContext;
import org.jvnet.ws.message.PropertySet;

public abstract class DistributedPropertySet
extends PropertySet {
    private final Map<Class, PropertySet> satellites = new IdentityHashMap<Class, PropertySet>();

    public void addSatellite(@NotNull PropertySet satellite) {
        this.addSatellite(satellite.getClass(), satellite);
    }

    public void addSatellite(@NotNull Class keyClass, @NotNull PropertySet satellite) {
        this.satellites.put(keyClass, satellite);
    }

    public void copySatelliteInto(@NotNull DistributedPropertySet r) {
        r.satellites.putAll(this.satellites);
    }

    @Nullable
    public <T extends PropertySet> T getSatellite(Class<T> satelliteClass) {
        PropertySet satellite = this.satellites.get(satelliteClass);
        if (satellite != null) {
            return (T)satellite;
        }
        for (PropertySet child : this.satellites.values()) {
            if (satelliteClass.isInstance(child)) {
                return (T)((PropertySet)satelliteClass.cast(child));
            }
            if (!DistributedPropertySet.class.isInstance(child) || (satellite = ((DistributedPropertySet)DistributedPropertySet.class.cast(child)).getSatellite(satelliteClass)) == null) continue;
            return (T)satellite;
        }
        return null;
    }

    @Override
    public Object get(Object key) {
        for (PropertySet child : this.satellites.values()) {
            if (!child.supports(key)) continue;
            return child.get(key);
        }
        return super.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        for (PropertySet child : this.satellites.values()) {
            if (!child.supports(key)) continue;
            return child.put(key, value);
        }
        return super.put(key, value);
    }

    @Override
    public boolean supports(Object key) {
        for (PropertySet child : this.satellites.values()) {
            if (!child.supports(key)) continue;
            return true;
        }
        return super.supports(key);
    }

    @Override
    public Object remove(Object key) {
        for (PropertySet child : this.satellites.values()) {
            if (!child.supports(key)) continue;
            return child.remove(key);
        }
        return super.remove(key);
    }

    @Override
    void createEntrySet(Set<Map.Entry<String, Object>> core) {
        super.createEntrySet(core);
        for (PropertySet child : this.satellites.values()) {
            child.createEntrySet(core);
        }
    }

    public void removeSatellite(PropertySet satellite) {
        this.removeSatellite(satellite);
    }

    public void copySatelliteInto(MessageContext r) {
        this.copySatelliteInto((DistributedPropertySet)r);
    }
}

