/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.metro.dev;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.config.metro.dev.FeatureReader;
import com.sun.xml.ws.config.metro.util.ParserUtil;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleFeatureReader<T extends WebServiceFeature>
implements FeatureReader {
    private static final Logger LOGGER = Logger.getLogger(SimpleFeatureReader.class);

    @Override
    public T parse(XMLEventReader reader) throws WebServiceException {
        try {
            boolean attributeEnabled = true;
            StartElement element = reader.nextEvent().asStartElement();
            QName elementName = element.getName();
            Iterator iterator = element.getAttributes();
            while (iterator.hasNext()) {
                Attribute nextAttribute = (Attribute)iterator.next();
                QName attributeName = nextAttribute.getName();
                if (ENABLED_ATTRIBUTE_NAME.equals(attributeName)) {
                    attributeEnabled = ParserUtil.parseBooleanValue(nextAttribute.getValue());
                    continue;
                }
                throw LOGGER.logSevereException(new WebServiceException("Unexpected attribute"));
            }
            EndElement endElement = reader.nextEvent().asEndElement();
            if (!elementName.equals(endElement.getName())) {
                throw LOGGER.logSevereException(new WebServiceException("Expected end element"));
            }
            return this.createFeature(attributeEnabled);
        }
        catch (XMLStreamException e) {
            throw LOGGER.logSevereException(new WebServiceException("Failed to unmarshal XML document", (Throwable)e));
        }
    }

    protected abstract T createFeature(boolean var1) throws WebServiceException;
}

