/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.policy.spi_impl;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.tx.at.Transactional;
import com.sun.xml.ws.api.tx.at.TransactionalFeature;
import com.sun.xml.ws.api.tx.at.WsatNamespace;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.ws.tx.at.localization.LocalizationMessages;
import com.sun.xml.ws.tx.at.policy.AtAssertion;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtFeatureConfigurator
implements PolicyFeatureConfigurator {
    private static final Logger LOGGER = Logger.getLogger(AtFeatureConfigurator.class);

    @Override
    public Collection<WebServiceFeature> getFeatures(PolicyMapKey endpointKey, PolicyMap policyMap) throws PolicyException {
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (endpointKey == null || policyMap == null) {
            return features;
        }
        TransactionalFeature endpointFeature = this.getAtFeature(policyMap.getEndpointEffectivePolicy(endpointKey), false);
        if (endpointFeature != null) {
            features.add(endpointFeature);
        }
        for (PolicyMapKey key : policyMap.getAllOperationScopeKeys()) {
            TransactionalFeature feature;
            if (!endpointKey.equals(key) || (feature = this.getAtFeature(policyMap.getOperationEffectivePolicy(key), true)) == null || !feature.isEnabled()) continue;
            if (endpointFeature == null) {
                endpointFeature = feature;
                features.add(endpointFeature);
            } else if (endpointFeature.getVersion() != feature.getVersion()) {
                throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSAT_1004_ENDPOINT_AND_OPERATION_POLICIES_DONT_MATCH(endpointKey, key)));
            }
            endpointFeature.setExplicitMode(true);
            String opName = key.getOperation().getLocalPart();
            feature.setFlowType(opName, feature.getFlowType());
            feature.setEnabled(opName, true);
        }
        return features;
    }

    private TransactionalFeature getAtFeature(Policy policy, boolean setExplictMode) throws WebServiceException, PolicyException {
        if (policy == null) {
            return null;
        }
        TransactionalFeature resultFeature = null;
        for (AssertionSet alternative : policy) {
            TransactionalFeature feature = this.getAtFeature(alternative, setExplictMode);
            if (feature == null) continue;
            if (resultFeature == null) {
                resultFeature = feature;
                continue;
            }
            if (AtFeatureConfigurator.areCompatible(resultFeature, feature)) continue;
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSAT_1003_INCOMPATIBLE_FEATURES_DETECTED(policy.toString())));
        }
        return resultFeature;
    }

    private TransactionalFeature getAtFeature(AssertionSet alternative, boolean setExplicitMode) throws PolicyException {
        TransactionalFeature feature = null;
        for (PolicyAssertion assertion : alternative) {
            if (!(assertion instanceof AtAssertion)) continue;
            if (feature != null) {
                throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSAT_1001_DUPLICATE_ASSERTION_IN_POLICY(alternative.toString())));
            }
            feature = new TransactionalFeature(true);
            feature.setExplicitMode(setExplicitMode);
            WsatNamespace version = WsatNamespace.forNamespaceUri(assertion.getName().getNamespaceURI());
            feature.setVersion(Transactional.Version.forNamespaceVersion(version));
            feature.setFlowType(assertion.isOptional() ? Transactional.TransactionFlowType.SUPPORTS : Transactional.TransactionFlowType.MANDATORY);
        }
        return feature;
    }

    private static boolean areCompatible(TransactionalFeature featureA, TransactionalFeature featureB) {
        boolean result = true;
        result = result && featureA.isEnabled() == featureB.isEnabled();
        result = result && featureA.getVersion() == featureB.getVersion();
        result = result && featureA.getFlowType() == featureB.getFlowType();
        return result;
    }
}

