/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import com.tailrocks.graphql.datetime.CoercingUtil;
import com.tailrocks.graphql.datetime.DateTimeHelper;
import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

@Internal
public class GraphqlLocalTimeCoercing
implements Coercing<LocalTime, String> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME.withZone(ZoneOffset.UTC);

    private LocalTime convertImpl(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            try {
                return LocalTime.parse(string, FORMATTER);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        } else if (input instanceof LocalTime) {
            LocalTime localTime = (LocalTime)input;
            return localTime;
        }
        return null;
    }

    public String serialize(Object input) {
        if (input instanceof LocalTime) {
            LocalTime localTime = (LocalTime)input;
            return DateTimeHelper.toISOString(localTime);
        }
        LocalTime result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(this.getErrorMessage(input));
        }
        return DateTimeHelper.toISOString(result);
    }

    public LocalTime parseValue(Object input) {
        LocalTime result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(this.getErrorMessage(input));
        }
        return result;
    }

    public LocalTime parseLiteral(Object input) {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        String value = ((StringValue)input).getValue();
        LocalTime result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException(this.getErrorMessage(input));
        }
        return result;
    }

    private String getErrorMessage(Object input) {
        return "Invalid value '" + input + "' for LocalTime";
    }
}

