/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import com.tailrocks.graphql.datetime.CoercingUtil;
import com.tailrocks.graphql.datetime.DateTimeHelper;
import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

@Internal
public class GraphqlDateCoercing
implements Coercing<Date, String> {
    private final List<DateTimeFormatter> formatters = new CopyOnWriteArrayList<DateTimeFormatter>();

    public GraphqlDateCoercing() {
        this(Collections.emptyList());
    }

    public GraphqlDateCoercing(Collection<DateTimeFormatter> formatters) {
        this.formatters.addAll(formatters);
        this.initBasicFormatters();
    }

    public String serialize(Object input) {
        if (input instanceof Date) {
            Date date = (Date)input;
            return DateTimeHelper.toISOString(date);
        }
        Date result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(this.getErrorMessage(input));
        }
        return DateTimeHelper.toISOString(result);
    }

    public Date parseValue(Object input) {
        Date result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(this.getErrorMessage(input));
        }
        return result;
    }

    public Date parseLiteral(Object input) {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        String value = ((StringValue)input).getValue();
        Date result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException(this.getErrorMessage(input));
        }
        return result;
    }

    private void initBasicFormatters() {
        this.formatters.add(DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC));
        this.formatters.add(DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneOffset.UTC));
        this.formatters.add(DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC));
    }

    private Date convertImpl(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            LocalDateTime localDateTime = this.parseDate(string);
            if (localDateTime != null) {
                return DateTimeHelper.toDate(localDateTime);
            }
        } else if (input instanceof Date) {
            Date date = (Date)input;
            return date;
        }
        return null;
    }

    private LocalDateTime parseDate(String date) {
        Objects.requireNonNull(date, "date");
        for (DateTimeFormatter formatter : this.formatters) {
            try {
                if (formatter.equals(this.formatters.get(2))) {
                    LocalDate localDate = LocalDate.parse(date, formatter);
                    return localDate.atStartOfDay();
                }
                return LocalDateTime.parse(date, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    private String getErrorMessage(Object input) {
        return "Invalid value '" + input + "' for Date";
    }
}

