/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import com.tailrocks.graphql.datetime.CoercingUtil;
import com.tailrocks.graphql.datetime.LocalDateTimeConverter;
import graphql.Internal;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Internal
public class GraphqlLocalDateCoercing
implements Coercing<LocalDate, String> {
    private final DateTimeFormatter formatter;
    private final LocalDateTimeConverter converter;

    public GraphqlLocalDateCoercing(boolean zoneConversionEnabled, DateTimeFormatter formatter) {
        this.formatter = formatter;
        this.converter = new LocalDateTimeConverter(zoneConversionEnabled, formatter);
    }

    public String serialize(Object input) {
        if (input instanceof LocalDate) {
            LocalDate localDate = (LocalDate)input;
            return this.converter.formatDate(localDate, this.formatter);
        }
        LocalDate result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(this.getErrorMessage(input));
        }
        return this.converter.formatDate(result, this.formatter);
    }

    public LocalDate parseValue(Object input) {
        LocalDate result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(this.getErrorMessage(input));
        }
        return result;
    }

    public LocalDate parseLiteral(Object input) {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + CoercingUtil.typeName(input) + "'.");
        }
        String value = ((StringValue)input).getValue();
        LocalDate result = this.convertImpl(value);
        if (result == null) {
            throw new CoercingParseLiteralException(this.getErrorMessage(input));
        }
        return result;
    }

    private LocalDate convertImpl(Object input) {
        if (input instanceof String) {
            String string = (String)input;
            LocalDateTime localDateTime = this.converter.parseDate(string);
            if (localDateTime != null) {
                return localDateTime.toLocalDate();
            }
        } else if (input instanceof LocalDate) {
            LocalDate localDate = (LocalDate)input;
            return localDate;
        }
        return null;
    }

    private String getErrorMessage(Object input) {
        return "Invalid value '" + input + "' for LocalDate";
    }
}

