/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import graphql.Internal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

@Internal
class LocalDateTimeConverter {
    private final boolean zoneConversionEnabled;
    private final List<DateTimeFormatter> formatters = new CopyOnWriteArrayList<DateTimeFormatter>();

    LocalDateTimeConverter(boolean zoneConversionEnabled, DateTimeFormatter formatter) {
        this.zoneConversionEnabled = zoneConversionEnabled;
        this.formatters.add(formatter);
        this.formatters.add(DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC));
        this.formatters.add(DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneOffset.UTC));
        this.formatters.add(DateTimeFormatter.ISO_LOCAL_DATE.withZone(ZoneOffset.UTC));
    }

    String formatDate(LocalDate date, DateTimeFormatter formatter) {
        Objects.requireNonNull(date, "date");
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(date);
    }

    String formatDate(LocalDateTime dateTime, DateTimeFormatter formatter) {
        Objects.requireNonNull(dateTime, "dateTime");
        Objects.requireNonNull(formatter, "formatter");
        return formatter.format(this.toUTC(dateTime));
    }

    LocalDateTime parseDate(String date) {
        Objects.requireNonNull(date, "date");
        for (DateTimeFormatter formatter : this.formatters) {
            try {
                LocalDateTime dateTime = LocalDateTime.parse(date, formatter);
                return this.fromUTC(dateTime);
            }
            catch (DateTimeParseException dateTime) {
                try {
                    LocalDate localDate = LocalDate.parse(date, formatter);
                    return localDate.atStartOfDay();
                }
                catch (DateTimeParseException dateTimeParseException) {
                }
            }
        }
        return null;
    }

    private LocalDateTime convert(LocalDateTime dateTime, ZoneId from, ZoneId to) {
        if (this.zoneConversionEnabled) {
            return dateTime.atZone(from).withZoneSameInstant(to).toLocalDateTime();
        }
        return dateTime;
    }

    private LocalDateTime fromUTC(LocalDateTime dateTime) {
        return this.convert(dateTime, ZoneOffset.UTC, ZoneId.systemDefault());
    }

    private ZonedDateTime toUTC(LocalDateTime dateTime) {
        return ZonedDateTime.of(this.convert(dateTime, ZoneId.systemDefault(), ZoneOffset.UTC), ZoneOffset.UTC);
    }
}

