/*
 * Decompiled with CFR 0.152.
 */
package com.tailrocks.graphql.datetime;

import graphql.Internal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Internal
final class DateTimeHelper {
    private DateTimeHelper() {
    }

    static String toISOString(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime, "dateTime");
        return DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.of(dateTime, ZoneOffset.UTC));
    }

    static String toISOString(LocalTime time) {
        Objects.requireNonNull(time, "time");
        return DateTimeFormatter.ISO_LOCAL_TIME.format(time);
    }

    static String toISOString(Date date) {
        Objects.requireNonNull(date, "date");
        return DateTimeHelper.toISOString(DateTimeHelper.toLocalDateTime(date));
    }

    static LocalDateTime toLocalDateTime(Date date) {
        Objects.requireNonNull(date, "date");
        return date.toInstant().atZone(ZoneOffset.UTC).toLocalDateTime();
    }

    static Date toDate(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime, "dateTime");
        return Date.from(dateTime.atZone(ZoneOffset.UTC).toInstant());
    }

    static Date createDate(int year, int month, int day) {
        return DateTimeHelper.createDate(year, month, day, 0, 0, 0, 0);
    }

    static Date createDate(int year, int month, int day, int hours, int min, int sec) {
        return DateTimeHelper.createDate(year, month, day, hours, min, sec, 0);
    }

    static Date createDate(int year, int month, int day, int hours, int min, int sec, int millis) {
        long nanos = TimeUnit.MILLISECONDS.toNanos(millis);
        LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hours, min, sec, (int)nanos);
        return DateTimeHelper.toDate(localDateTime);
    }
}

