/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal.comm;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineTransportException;
import com.taskadapter.redmineapi.internal.comm.BasicHttpResponse;
import com.taskadapter.redmineapi.internal.comm.ContentHandler;
import com.taskadapter.redmineapi.internal.comm.HttpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

final class TransportDecoder
implements ContentHandler<HttpResponse, BasicHttpResponse> {
    TransportDecoder() {
    }

    @Override
    public BasicHttpResponse processContent(HttpResponse content) throws RedmineException {
        HttpEntity entity = content.getEntity();
        String charset = HttpUtil.getCharset(entity);
        String encoding = HttpUtil.getEntityEncoding(entity);
        try {
            InputStream initialStream = entity.getContent();
            return new BasicHttpResponse(content.getStatusLine().getStatusCode(), this.decodeStream(encoding, initialStream), charset);
        }
        catch (IOException e) {
            throw new RedmineTransportException(e);
        }
    }

    private InputStream decodeStream(String encoding, InputStream initialStream) throws IOException {
        if (encoding == null) {
            return initialStream;
        }
        if ("gzip".equals(encoding)) {
            return new GZIPInputStream(initialStream);
        }
        if ("deflate".equals(encoding)) {
            return new InflaterInputStream(initialStream);
        }
        throw new IOException("Unsupported transport encoding " + encoding);
    }
}

