/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.ExecutionMode;
import com.theoryinpractise.clojure.NamespaceDiscovery;
import com.theoryinpractise.clojure.NamespaceInFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClojureCompilerMojo
extends AbstractMojo {
    protected MavenProject project;
    private ToolchainManager toolchainManager;
    private MavenSession session;
    protected File baseDirectory;
    protected List<String> classpathElements;
    protected List<String> testClasspathElements;
    protected File outputDirectory;
    protected File testOutputDirectory;
    protected String[] sourceDirectories = new String[]{"src/main/clojure"};
    protected String[] testSourceDirectories = new String[]{"src/test/clojure"};
    protected File baseTestSourceDirectory;
    protected File generatedSourceDirectory;
    protected File workingDirectory;
    protected boolean compileDeclaredNamespaceOnly;
    protected String[] namespaces;
    protected boolean testDeclaredNamespaceOnly;
    protected String[] testNamespaces;
    private List<String> prependClasses;
    private String clojureOptions = "";
    private boolean runWithTests;
    protected String[] copiedNamespaces;
    protected boolean copyDeclaredNamespaceOnly;
    private boolean copyAllCompiledNamespaces;
    private boolean warnOnReflection;
    private String vmargs;

    protected String escapeFilePath(String directory, String file) {
        return this.escapeFilePath(new File(directory, file));
    }

    protected String escapeFilePath(File file) {
        return file.getPath().replace("\\", "\\\\");
    }

    private String getJavaExecutable() throws MojoExecutionException {
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in clojure-maven-plugin: " + tc));
            String foundExecutable = tc.findTool("java");
            if (foundExecutable != null) {
                return foundExecutable;
            }
            throw new MojoExecutionException("Unable to find 'java' executable for toolchain: " + tc);
        }
        return "java";
    }

    protected File getWorkingDirectory() throws MojoExecutionException {
        if (this.workingDirectory != null) {
            if (this.workingDirectory.exists()) {
                return this.workingDirectory;
            }
            throw new MojoExecutionException("Directory specified in <workingDirectory/> does not exists: " + this.workingDirectory.getPath());
        }
        return this.session.getCurrentProject().getBasedir();
    }

    private File[] translatePaths(String[] paths) {
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(this.baseDirectory, paths[i]);
        }
        return files;
    }

    protected NamespaceInFile[] discoverNamespaces() throws MojoExecutionException {
        return new NamespaceDiscovery(this.getLog(), this.outputDirectory, this.compileDeclaredNamespaceOnly, false).discoverNamespacesIn(this.namespaces, this.translatePaths(this.sourceDirectories));
    }

    protected NamespaceInFile[] discoverNamespacesToCopy() throws MojoExecutionException {
        if (this.copyAllCompiledNamespaces) {
            return this.discoverNamespaces();
        }
        return new NamespaceDiscovery(this.getLog(), this.outputDirectory, this.copyDeclaredNamespaceOnly, false).discoverNamespacesIn(this.copiedNamespaces, this.translatePaths(this.sourceDirectories));
    }

    public String getSourcePath(SourceDirectory ... sourceDirectoryTypes) {
        return this.getPath(this.getSourceDirectories(sourceDirectoryTypes));
    }

    public File[] getSourceDirectories(SourceDirectory ... sourceDirectoryTypes) {
        ArrayList<File> dirs = new ArrayList<File>();
        if (Arrays.asList(sourceDirectoryTypes).contains((Object)SourceDirectory.COMPILE)) {
            dirs.add(this.generatedSourceDirectory);
            dirs.addAll(Arrays.asList(this.translatePaths(this.sourceDirectories)));
        }
        if (Arrays.asList(sourceDirectoryTypes).contains((Object)SourceDirectory.TEST)) {
            dirs.add(this.baseTestSourceDirectory);
            dirs.addAll(Arrays.asList(this.translatePaths(this.testSourceDirectories)));
        }
        return dirs.toArray(new File[0]);
    }

    private String getPath(File[] sourceDirectory) {
        String cp = "";
        for (File directory : sourceDirectory) {
            cp = cp + directory.getPath() + File.pathSeparator;
        }
        return cp.substring(0, cp.length() - 1);
    }

    public List<String> getRunWithClasspathElements() {
        return this.runWithTests ? this.testClasspathElements : this.classpathElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyNamespaceSourceFilesToOutput(File outputDirectory, NamespaceInFile[] discoveredNamespaces) throws MojoExecutionException {
        for (NamespaceInFile ns : discoveredNamespaces) {
            File outputFile = new File(outputDirectory, ns.getFilename());
            outputFile.getParentFile().mkdirs();
            try {
                FileInputStream is = new FileInputStream(ns.getSourceFile());
                try {
                    FileOutputStream os = new FileOutputStream(outputFile);
                    try {
                        int amountRead;
                        byte[] buffer = new byte[4096];
                        while ((amountRead = is.read(buffer)) >= 0) {
                            os.write(buffer, 0, amountRead);
                        }
                        is.close();
                    }
                    finally {
                        is.close();
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Couldn't copy the clojure source files to the output", (Exception)ex);
            }
        }
    }

    protected void callClojureWith(File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements, String mainClass, NamespaceInFile[] namespaceArgs) throws MojoExecutionException {
        this.callClojureWith(ExecutionMode.BATCH, sourceDirectory, outputDirectory, compileClasspathElements, mainClass, namespaceArgs);
    }

    protected void callClojureWith(File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements, String mainClass, String[] clojureArgs) throws MojoExecutionException {
        this.callClojureWith(ExecutionMode.BATCH, sourceDirectory, outputDirectory, compileClasspathElements, mainClass, clojureArgs);
    }

    protected void callClojureWith(ExecutionMode executionMode, File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements, String mainClass, NamespaceInFile[] namespaceArgs) throws MojoExecutionException {
        String[] stringArgs = new String[namespaceArgs.length];
        for (int i = 0; i < namespaceArgs.length; ++i) {
            stringArgs[i] = namespaceArgs[i].getName();
        }
        this.callClojureWith(executionMode, sourceDirectory, outputDirectory, compileClasspathElements, mainClass, stringArgs);
    }

    protected void callClojureWith(ExecutionMode executionMode, File[] sourceDirectory, File outputDirectory, List<String> compileClasspathElements, String mainClass, String[] clojureArgs) throws MojoExecutionException {
        int status;
        outputDirectory.mkdirs();
        String cp = this.getPath(sourceDirectory);
        cp = cp + File.pathSeparator + outputDirectory.getPath() + File.pathSeparator;
        for (String classpathElement : compileClasspathElements) {
            cp = cp + File.pathSeparator + classpathElement;
        }
        cp = cp.replaceAll("\\s", "\\ ");
        String javaExecutable = this.getJavaExecutable();
        this.getLog().debug((CharSequence)("Java exectuable used:  " + javaExecutable));
        this.getLog().debug((CharSequence)("Clojure classpath: " + cp));
        CommandLine cl = null;
        if (ExecutionMode.INTERACTIVE == executionMode && SystemUtils.IS_OS_WINDOWS) {
            cl = new CommandLine("cmd");
            cl.addArgument("/c");
            cl.addArgument("start");
            cl.addArgument(javaExecutable);
        } else {
            cl = new CommandLine(javaExecutable);
        }
        if (this.vmargs != null) {
            cl.addArguments(this.vmargs, false);
        }
        cl.addArgument("-cp");
        cl.addArgument(cp, false);
        cl.addArgument("-Dclojure.compile.path=" + this.escapeFilePath(outputDirectory), false);
        if (this.warnOnReflection) {
            cl.addArgument("-Dclojure.compile.warn-on-reflection=true");
        }
        cl.addArguments(this.clojureOptions, false);
        if (this.prependClasses != null) {
            cl.addArguments(this.prependClasses.toArray(new String[this.prependClasses.size()]));
        }
        cl.addArgument(mainClass);
        if (clojureArgs != null) {
            cl.addArguments(clojureArgs, false);
        }
        this.getLog().debug((CharSequence)("Command line: " + cl.toString()));
        DefaultExecutor exec = new DefaultExecutor();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in);
        exec.setStreamHandler((ExecuteStreamHandler)handler);
        exec.setWorkingDirectory(this.getWorkingDirectory());
        try {
            status = exec.execute(cl, env);
        }
        catch (ExecuteException e) {
            status = e.getExitValue();
        }
        catch (IOException e) {
            status = 1;
        }
        if (status != 0) {
            throw new MojoExecutionException("Clojure failed.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceDirectory {
        COMPILE,
        TEST;

    }
}

