/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class ClojureAutodocMojo
extends AbstractClojureCompilerMojo {
    private String projectName;
    private String projectDescription;
    private String projectBuildDir;
    private String autodocTargetDirectory;
    private Map<String, String> autodoc;

    public void execute() throws MojoExecutionException {
        HashMap<String, String> effectiveProps = new HashMap<String, String>();
        effectiveProps.put("name", this.projectName);
        effectiveProps.put("description", this.projectDescription);
        effectiveProps.put("param-dir", "src/main/autodoc");
        effectiveProps.put("root", ".");
        effectiveProps.put("source-path", this.sourceDirectories[0]);
        effectiveProps.put("output-path", new File(this.autodocTargetDirectory).getAbsolutePath());
        effectiveProps.put("page-title", this.projectName);
        if (this.autodoc != null) {
            effectiveProps.putAll(this.autodoc);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(use 'autodoc.autodoc)\n");
        sb.append("(autodoc {\n");
        for (Map.Entry entry : effectiveProps.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append(" :" + key);
            if (value != null) {
                sb.append(" \"" + value.replace("\\", "\\\\") + "\"");
            } else {
                sb.append(" nil");
            }
            sb.append("\n");
        }
        sb.append("})\n");
        try {
            File autodocClj = File.createTempFile("autodoc", ".clj");
            PrintWriter pw = new PrintWriter(autodocClj);
            pw.print(sb.toString());
            pw.close();
            this.getLog().info((CharSequence)("Generating docs to " + (String)effectiveProps.get("output-path") + " with " + autodocClj.getPath()));
            this.getLog().debug((CharSequence)sb.toString());
            this.callClojureWith(this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.COMPILE, AbstractClojureCompilerMojo.SourceDirectory.TEST), this.outputDirectory, (List<String>)this.testClasspathElements, "clojure.main", new String[]{autodocClj.getPath()});
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

