/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import com.theoryinpractise.clojure.NamespaceDiscovery;
import com.theoryinpractise.clojure.NamespaceInFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ClojureRunTestMojo
extends AbstractClojureCompilerMojo {
    private boolean skip;
    private boolean skipTests;
    private String testScript;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipTests) {
            this.getLog().info((CharSequence)"Test execution is skipped");
        } else {
            File[] testSourceDirectories = this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST);
            File[] allSourceDirectories = this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST, AbstractClojureCompilerMojo.SourceDirectory.COMPILE);
            if (this.testScript == null || "".equals(this.testScript)) {
                try {
                    NamespaceInFile[] ns = new NamespaceDiscovery(this.getLog(), this.testOutputDirectory, this.testDeclaredNamespaceOnly).discoverNamespacesIn(this.testNamespaces, testSourceDirectories);
                    File testFile = File.createTempFile("run-test", ".clj");
                    PrintWriter writer = new PrintWriter(new FileWriter(testFile));
                    for (NamespaceInFile namespace : ns) {
                        writer.println("(require '" + namespace.getName() + ")");
                    }
                    String testClj = this.generateTestScript(ns);
                    writer.println(testClj);
                    writer.close();
                    this.testScript = testFile.getPath();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            } else {
                File testFile = new File(this.testScript);
                if (!testFile.exists()) {
                    testFile = new File(this.getWorkingDirectory(), this.testScript);
                }
                if (!testFile.exists()) {
                    throw new MojoExecutionException("testScript " + testFile.getPath() + " does not exist.");
                }
            }
            this.getLog().debug((CharSequence)("Running clojure:test against " + this.testScript));
            this.callClojureWith(allSourceDirectories, this.outputDirectory, (List<String>)this.testClasspathElements, "clojure.main", new String[]{this.testScript});
        }
    }

    protected String generateTestScript(NamespaceInFile[] ns) throws IOException {
        StringWriter testCljWriter = new StringWriter();
        IOUtils.copy((InputStream)ClojureRunTestMojo.class.getResourceAsStream("/default_test_script.clj"), (Writer)testCljWriter);
        StringBuilder runTestLine = new StringBuilder();
        runTestLine.append("(run-tests");
        for (NamespaceInFile namespace : ns) {
            runTestLine.append(" '" + namespace.getName());
        }
        runTestLine.append(")");
        return testCljWriter.toString().replace("(run-tests)", runTestLine.toString());
    }
}

