/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import com.theoryinpractise.clojure.NamespaceDiscovery;
import com.theoryinpractise.clojure.NamespaceInFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="test-with-junit", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class ClojureRunTestWithJUnitMojo
extends AbstractClojureCompilerMojo {
    @Parameter(required=true, property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(required=true, property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter
    private String testScript;
    @Parameter(defaultValue="${project.build.directory}/test-reports", property="clojure.testOutputDirectory")
    private String testOutputDirectory;
    @Parameter(defaultValue="true", property="clojure.xmlEscapeOutput")
    private boolean xmlEscapeOutput;

    public void execute() throws MojoExecutionException {
        if (this.skip || this.skipTests) {
            this.getLog().info((CharSequence)"Test execution is skipped");
        } else {
            File[] testSourceDirectories = this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST);
            File[] allSourceDirectories = this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST, AbstractClojureCompilerMojo.SourceDirectory.COMPILE);
            if (this.testScript == null || "".equals(this.testScript) || !new File(this.testScript).exists()) {
                try {
                    File outputFile = new File(this.testOutputDirectory);
                    outputFile.mkdir();
                    NamespaceInFile[] ns = new NamespaceDiscovery(this.getLog(), outputFile, this.testDeclaredNamespaceOnly).discoverNamespacesIn(this.testNamespaces, testSourceDirectories);
                    File testFile = File.createTempFile("run-test", ".clj");
                    PrintWriter writer = new PrintWriter(new FileWriter(testFile));
                    for (NamespaceInFile namespace : ns) {
                        writer.println("(require '" + namespace.getName() + ")");
                    }
                    StringWriter testCljWriter = new StringWriter();
                    IOUtils.copy((InputStream)ClojureRunTestWithJUnitMojo.class.getResourceAsStream("/default_test_script.clj"), (Writer)testCljWriter);
                    StringBuilder runTestLine = new StringBuilder();
                    for (NamespaceInFile namespace : ns) {
                        if (this.xmlEscapeOutput) {
                            runTestLine.append("\n");
                            runTestLine.append("(with-open [writer (clojure.java.io/writer \"" + this.escapeFilePath(this.testOutputDirectory, namespace.getName() + ".xml") + "\") ");
                            runTestLine.append("            escaped (xml-escaping-writer writer)] ");
                            runTestLine.append("\n");
                            runTestLine.append("(binding [*test-out* writer *out* escaped]");
                            runTestLine.append("\n");
                            runTestLine.append(" (with-junit-output ");
                            runTestLine.append("\n");
                            runTestLine.append("(run-tests");
                            runTestLine.append(" '" + namespace.getName());
                            runTestLine.append("))))");
                            continue;
                        }
                        runTestLine.append("\n");
                        runTestLine.append("(with-open [writer (clojure.java.io/writer \"" + this.escapeFilePath(this.testOutputDirectory, namespace.getName() + ".xml") + "\")] ");
                        runTestLine.append("(binding [*test-out* writer] ");
                        runTestLine.append("\n");
                        runTestLine.append(" (with-test-out ");
                        runTestLine.append("\n");
                        runTestLine.append(" (with-junit-output ");
                        runTestLine.append("\n");
                        runTestLine.append("(run-tests");
                        runTestLine.append(" '" + namespace.getName());
                        runTestLine.append(")))))");
                    }
                    String testClj = testCljWriter.toString().replace("(run-tests)", runTestLine.toString());
                    writer.println(testClj);
                    writer.close();
                    this.testScript = testFile.getPath();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            } else {
                File testFile = new File(this.testScript);
                if (!testFile.exists()) {
                    testFile = new File(this.getWorkingDirectory(), this.testScript);
                }
                if (!testFile.exists()) {
                    throw new MojoExecutionException("testScript " + testFile.getPath() + " does not exist.");
                }
            }
            this.getLog().debug((CharSequence)("Running clojure:test-with-junit against " + this.testScript));
            this.callClojureWith(allSourceDirectories, this.outputDirectory, (List<String>)this.testClasspathElements, "clojure.main", new String[]{this.testScript});
        }
    }
}

