/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2;

import net.minidev.json.JSONObject;

public class JSONRPC2Error
extends Exception {
    private static final long serialVersionUID = 4682571044532698806L;
    public static final JSONRPC2Error PARSE_ERROR = new JSONRPC2Error(-32700, "JSON parse error");
    public static final JSONRPC2Error INVALID_REQUEST = new JSONRPC2Error(-32600, "Invalid request");
    public static final JSONRPC2Error METHOD_NOT_FOUND = new JSONRPC2Error(-32601, "Method not found");
    public static final JSONRPC2Error INVALID_PARAMS = new JSONRPC2Error(-32602, "Invalid parameters");
    public static final JSONRPC2Error INTERNAL_ERROR = new JSONRPC2Error(-32603, "Internal error");
    private final int code;
    private final Object data;

    @Deprecated
    public static JSONRPC2Error appendMessage(JSONRPC2Error err, String apx) {
        return new JSONRPC2Error(err.getCode(), err.getMessage() + apx, err.getData());
    }

    @Deprecated
    public static JSONRPC2Error setData(JSONRPC2Error err, Object data) {
        return new JSONRPC2Error(err.getCode(), err.getMessage(), data);
    }

    public JSONRPC2Error(int code, String message) {
        this(code, message, null);
    }

    public JSONRPC2Error(int code, String message, Object data) {
        super(message);
        this.code = code;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public Object getData() {
        return this.data;
    }

    public JSONRPC2Error setData(Object data) {
        return new JSONRPC2Error(this.code, this.getMessage(), data);
    }

    public JSONRPC2Error appendMessage(String apx) {
        return new JSONRPC2Error(this.code, this.getMessage() + apx, this.data);
    }

    @Deprecated
    public JSONObject toJSON() {
        return this.toJSONObject();
    }

    public JSONObject toJSONObject() {
        JSONObject out = new JSONObject();
        out.put((Object)"code", (Object)this.code);
        out.put((Object)"message", (Object)super.getMessage());
        if (this.data != null) {
            out.put((Object)"data", this.data);
        }
        return out;
    }

    @Override
    public String toString() {
        return this.toJSON().toString();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof JSONRPC2Error && this.code == ((JSONRPC2Error)object).getCode();
    }
}

