/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.MemCacheDaemon;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCache<CACHE_ELEMENT extends CacheElement>
implements Cache<CACHE_ELEMENT> {
    protected final AtomicLong started = new AtomicLong();
    protected final AtomicInteger getCmds = new AtomicInteger();
    protected final AtomicInteger setCmds = new AtomicInteger();
    protected final AtomicInteger getHits = new AtomicInteger();
    protected final AtomicInteger getMisses = new AtomicInteger();
    protected final AtomicLong casCounter = new AtomicLong(1L);

    public AbstractCache() {
        this.initStats();
    }

    public static int Now() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    protected abstract Set<Key> keys();

    @Override
    public abstract long getCurrentItems();

    @Override
    public abstract long getLimitMaxBytes();

    @Override
    public abstract long getCurrentBytes();

    @Override
    public final int getGetCmds() {
        return this.getCmds.get();
    }

    @Override
    public final int getSetCmds() {
        return this.setCmds.get();
    }

    @Override
    public final int getGetHits() {
        return this.getHits.get();
    }

    @Override
    public final int getGetMisses() {
        return this.getMisses.get();
    }

    @Override
    public final Map<String, Set<String>> stat(String arg) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        this.multiSet(result, "version", MemCacheDaemon.memcachedVersion);
        this.multiSet(result, "cmd_gets", String.valueOf(this.getGetCmds()));
        this.multiSet(result, "cmd_sets", String.valueOf(this.getSetCmds()));
        this.multiSet(result, "get_hits", String.valueOf(this.getGetHits()));
        this.multiSet(result, "get_misses", String.valueOf(this.getGetMisses()));
        this.multiSet(result, "time", String.valueOf(String.valueOf(AbstractCache.Now())));
        this.multiSet(result, "uptime", String.valueOf((long)AbstractCache.Now() - this.started.longValue()));
        this.multiSet(result, "cur_items", String.valueOf(this.getCurrentItems()));
        this.multiSet(result, "limit_maxbytes", String.valueOf(this.getLimitMaxBytes()));
        this.multiSet(result, "current_bytes", String.valueOf(this.getCurrentBytes()));
        this.multiSet(result, "free_bytes", String.valueOf(Runtime.getRuntime().freeMemory()));
        this.multiSet(result, "pid", String.valueOf(Thread.currentThread().getId()));
        this.multiSet(result, "rusage_user", "0:0");
        this.multiSet(result, "rusage_system", "0:0");
        this.multiSet(result, "connection_structures", "0");
        this.multiSet(result, "bytes_read", "0");
        this.multiSet(result, "bytes_written", "0");
        return result;
    }

    private void multiSet(Map<String, Set<String>> map, String key, String val) {
        Set<String> cur = map.get(key);
        if (cur == null) {
            cur = new HashSet<String>();
        }
        cur.add(val);
        map.put(key, cur);
    }

    protected void initStats() {
        this.started.set(System.currentTimeMillis());
    }

    @Override
    public abstract void asyncEventPing();
}

