/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import com.thimbleware.jmemcached.AbstractCache;
import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.Key;
import com.thimbleware.jmemcached.LocalCacheElement;
import com.thimbleware.jmemcached.storage.CacheStorage;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CacheImpl
extends AbstractCache<LocalCacheElement>
implements Cache<LocalCacheElement> {
    final CacheStorage<Key, LocalCacheElement> storage;
    final DelayQueue<DelayedMCElement> deleteQueue;
    private final ScheduledExecutorService scavenger;

    public CacheImpl(CacheStorage<Key, LocalCacheElement> storage) {
        this.storage = storage;
        this.deleteQueue = new DelayQueue();
        this.scavenger = Executors.newScheduledThreadPool(1);
        this.scavenger.scheduleAtFixedRate(new Runnable(){

            public void run() {
                CacheImpl.this.asyncEventPing();
            }
        }, 10L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public Cache.DeleteResponse delete(Key key, int time) {
        boolean removed = false;
        if (time != 0) {
            LocalCacheElement placeHolder = new LocalCacheElement(key, 0, 0, 0L);
            placeHolder.setData(ChannelBuffers.buffer((int)0));
            placeHolder.block((long)CacheImpl.Now() + (long)time);
            this.storage.replace(key, placeHolder);
            this.deleteQueue.add(new DelayedMCElement(placeHolder));
        } else {
            boolean bl = removed = this.storage.remove(key) != null;
        }
        if (removed) {
            return Cache.DeleteResponse.DELETED;
        }
        return Cache.DeleteResponse.NOT_FOUND;
    }

    @Override
    public Cache.StoreResponse add(LocalCacheElement e) {
        boolean stored;
        long origCasUnique = e.getCasUnique();
        e.setCasUnique(this.casCounter.getAndIncrement());
        boolean bl = stored = this.storage.putIfAbsent(e.getKey(), e) == null;
        if (!stored) {
            e.setCasUnique(origCasUnique);
        }
        return stored ? Cache.StoreResponse.STORED : Cache.StoreResponse.NOT_STORED;
    }

    @Override
    public Cache.StoreResponse replace(LocalCacheElement e) {
        return this.storage.replace(e.getKey(), e) != null ? Cache.StoreResponse.STORED : Cache.StoreResponse.NOT_STORED;
    }

    @Override
    public Cache.StoreResponse append(LocalCacheElement element) {
        LocalCacheElement old = (LocalCacheElement)this.storage.get(element.getKey());
        if (old == null || this.isBlocked(old) || this.isExpired(old)) {
            this.getMisses.incrementAndGet();
            return Cache.StoreResponse.NOT_FOUND;
        }
        return this.storage.replace(old.getKey(), old, old.append(element)) ? Cache.StoreResponse.STORED : Cache.StoreResponse.NOT_STORED;
    }

    @Override
    public Cache.StoreResponse prepend(LocalCacheElement element) {
        LocalCacheElement old = (LocalCacheElement)this.storage.get(element.getKey());
        if (old == null || this.isBlocked(old) || this.isExpired(old)) {
            this.getMisses.incrementAndGet();
            return Cache.StoreResponse.NOT_FOUND;
        }
        return this.storage.replace(old.getKey(), old, old.prepend(element)) ? Cache.StoreResponse.STORED : Cache.StoreResponse.NOT_STORED;
    }

    @Override
    public Cache.StoreResponse set(LocalCacheElement e) {
        this.setCmds.incrementAndGet();
        e.setCasUnique(this.casCounter.getAndIncrement());
        this.storage.put(e.getKey(), e);
        return Cache.StoreResponse.STORED;
    }

    @Override
    public Cache.StoreResponse cas(Long cas_key, LocalCacheElement e) {
        LocalCacheElement element = (LocalCacheElement)this.storage.get(e.getKey());
        if (element == null || this.isBlocked(element)) {
            this.getMisses.incrementAndGet();
            return Cache.StoreResponse.NOT_FOUND;
        }
        if (element.getCasUnique() == cas_key.longValue()) {
            e.setCasUnique(this.casCounter.getAndIncrement());
            if (this.storage.replace(e.getKey(), element, e)) {
                return Cache.StoreResponse.STORED;
            }
            this.getMisses.incrementAndGet();
            return Cache.StoreResponse.NOT_FOUND;
        }
        return Cache.StoreResponse.EXISTS;
    }

    @Override
    public Integer get_add(Key key, int mod) {
        LocalCacheElement old = (LocalCacheElement)this.storage.get(key);
        if (old == null || this.isBlocked(old) || this.isExpired(old)) {
            this.getMisses.incrementAndGet();
            return null;
        }
        LocalCacheElement.IncrDecrResult result = old.add(mod);
        return this.storage.replace(old.getKey(), old, result.replace) ? Integer.valueOf(result.oldValue) : null;
    }

    protected boolean isBlocked(CacheElement e) {
        return e.isBlocked() && e.getBlockedUntil() > (long)CacheImpl.Now();
    }

    protected boolean isExpired(CacheElement e) {
        return e.getExpire() != 0 && e.getExpire() < CacheImpl.Now();
    }

    public LocalCacheElement[] get(Key ... keys) {
        this.getCmds.incrementAndGet();
        LocalCacheElement[] elements = new LocalCacheElement[keys.length];
        int x = 0;
        int hits = 0;
        int misses = 0;
        for (Key key : keys) {
            LocalCacheElement e = (LocalCacheElement)this.storage.get(key);
            if (e == null || this.isExpired(e) || e.isBlocked()) {
                ++misses;
                elements[x] = null;
            } else {
                ++hits;
                elements[x] = e;
            }
            ++x;
        }
        this.getMisses.addAndGet(misses);
        this.getHits.addAndGet(hits);
        return elements;
    }

    @Override
    public boolean flush_all() {
        return this.flush_all(0);
    }

    @Override
    public boolean flush_all(int expire) {
        this.storage.clear();
        return true;
    }

    @Override
    public void close() throws IOException {
        this.scavenger.shutdown();
        this.storage.close();
    }

    @Override
    protected Set<Key> keys() {
        return this.storage.keySet();
    }

    @Override
    public long getCurrentItems() {
        return this.storage.size();
    }

    @Override
    public long getLimitMaxBytes() {
        return this.storage.getMemoryCapacity();
    }

    @Override
    public long getCurrentBytes() {
        return this.storage.getMemoryUsed();
    }

    @Override
    public void asyncEventPing() {
        DelayedMCElement toDelete = (DelayedMCElement)this.deleteQueue.poll();
        if (toDelete != null) {
            this.storage.remove(toDelete.element.getKey());
        }
    }

    protected static class DelayedMCElement
    implements Delayed {
        private CacheElement element;

        public DelayedMCElement(CacheElement element) {
            this.element = element;
        }

        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.element.getBlockedUntil() - (long)AbstractCache.Now(), TimeUnit.MILLISECONDS);
        }

        public int compareTo(Delayed delayed) {
            if (!(delayed instanceof DelayedMCElement)) {
                return -1;
            }
            return this.element.getKey().toString().compareTo(((DelayedMCElement)delayed).element.getKey().toString());
        }
    }
}

