/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift;

import com.thinkaurelius.thrift.AbstractDisruptorTest;
import com.thinkaurelius.thrift.test.TestService;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.thrift.transport.TTransport;
import org.junit.Test;

public abstract class AbstractMultiRequestTest
extends AbstractDisruptorTest {
    private static final int REQUESTS = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multiRequestTest() throws Exception {
        try (TTransport transport = this.getNewTransport();){
            TestService.Client client = this.getNewClient(transport);
            for (int i = 0; i < 500; i += 4) {
                this.invokeRequests(client, i, AbstractMultiRequestTest.getRandomArgument(), AbstractMultiRequestTest.getRandomArgument());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentMultiRequestTest() throws Exception {
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        TTransport transport = this.getNewTransport();
        try {
            final TestService.Client client = this.getNewClient(transport);
            final AtomicInteger id = new AtomicInteger(0);
            final ReentrantLock lock = new ReentrantLock();
            final CountDownLatch latch = new CountDownLatch(500);
            for (int i = 0; i < 500; ++i) {
                service.submit(new Callable<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object call() throws Exception {
                        lock.lock();
                        try {
                            AbstractMultiRequestTest.this.invokeRequests(client, id.incrementAndGet(), AbstractDisruptorTest.getRandomArgument(), AbstractDisruptorTest.getRandomArgument());
                        }
                        finally {
                            lock.unlock();
                        }
                        latch.countDown();
                        return null;
                    }
                });
            }
            latch.await();
        }
        finally {
            service.shutdown();
            transport.close();
        }
    }
}

