/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.cassandra.thrift.thriftpool;

import com.thinkaurelius.titan.diskstorage.cassandra.thrift.thriftpool.CTConnection;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTConnectionPool
extends GenericKeyedObjectPool<String, CTConnection> {
    private static final Logger log = LoggerFactory.getLogger(CTConnectionPool.class);

    public CTConnectionPool(KeyedPoolableObjectFactory<String, CTConnection> factory) {
        super(factory);
    }

    public void returnObjectUnsafe(String keyspace, CTConnection conn) {
        if (conn != null && conn.isOpen()) {
            try {
                this.returnObject(keyspace, conn);
            }
            catch (Exception e) {
                log.warn("Failed to return Cassandra connection to pool", (Throwable)e);
                log.warn("Failure context: keyspace={}, pool={}, connection={}", new Object[]{keyspace, this, conn});
            }
        }
    }
}

