/*
 * Decompiled with CFR 0.152.
 */
package com.thomaskasene.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.thomaskasene.wiremock.junit.WireMockStub;
import com.thomaskasene.wiremock.junit.WireMockStubs;
import com.thomaskasene.wiremock.junit.WireMockStubsConfiguration;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WireMockJunitExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger log = LoggerFactory.getLogger(WireMockJunitExtension.class);
    private WireMockStubsConfiguration configuration;
    private WireMockServer server;
    private Map<Class<? extends WireMockStub>, WireMockStub> stubs;

    WireMockJunitExtension() {
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        WireMockStubs annotation = this.findAnnotation(context);
        ExtensionContext.Store store = context.getRoot().getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass()}));
        String storedServerKey = annotation + " server";
        this.server = (WireMockServer)store.get((Object)storedServerKey, WireMockServer.class);
        String storedStubsKey = annotation + " stubs";
        this.stubs = (Map)store.get((Object)storedStubsKey, Map.class);
        this.createStubs(annotation.value());
        this.createConfiguration(annotation.configClass());
        this.createServer();
        this.startServer();
        store.put((Object)storedServerKey, (Object)this.server);
        store.put((Object)storedStubsKey, this.stubs);
        for (WireMockStub wireMockStub : this.stubs.values()) {
            wireMockStub.beforeAll();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.injectStubsIntoTestClass(context.getRequiredTestInstance(), context.getRequiredTestInstance().getClass());
        this.configuration.resetBeforeEachTest(this.stubs.values());
        for (WireMockStub wireMockStub : this.stubs.values()) {
            wireMockStub.beforeEach();
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        for (WireMockStub wireMockStub : this.stubs.values()) {
            wireMockStub.afterEach();
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        for (WireMockStub wireMockStub : this.stubs.values()) {
            wireMockStub.afterAll();
        }
    }

    private WireMockStubs findAnnotation(ExtensionContext context) {
        WireMockStubs annotation = ((Class)context.getTestClass().get()).getAnnotation(WireMockStubs.class);
        if (annotation != null) {
            return annotation;
        }
        throw new RuntimeException("Failed to find the @" + WireMockStubs.class.getSimpleName() + "-annotation for the current test context");
    }

    private void createStubs(Class<? extends WireMockStub>[] stubClasses) {
        if (this.stubs == null) {
            this.stubs = new LinkedHashMap<Class<? extends WireMockStub>, WireMockStub>(stubClasses.length);
            for (Class<? extends WireMockStub> stubClass : stubClasses) {
                WireMockStub stub = this.createStub(stubClass);
                this.stubs.put(stubClass, stub);
            }
        }
    }

    private WireMockStub createStub(Class<? extends WireMockStub> stubClass) {
        try {
            return stubClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create the stub " + stubClass.getSimpleName() + ". Does it have a public default constructor?", exception);
        }
    }

    private void createConfiguration(Class<? extends WireMockStubsConfiguration> configClass) {
        try {
            this.configuration = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create the configuration " + configClass.getSimpleName() + ". Does it have a public default constructor?", exception);
        }
    }

    private void createServer() {
        if (this.server == null) {
            WireMockConfiguration wireMockConfiguration = this.configuration.getWireMockConfiguration();
            this.configureWithStubsAsExtensions(wireMockConfiguration);
            this.server = new WireMockServer((Options)wireMockConfiguration);
        }
    }

    private void configureWithStubsAsExtensions(WireMockConfiguration wireMockConfiguration) {
        this.stubs.values().stream().filter(wireMockStub -> wireMockStub instanceof Extension).map(wireMockStub -> (Extension)wireMockStub).forEach(xva$0 -> wireMockConfiguration.extensions(new Extension[]{xva$0}));
    }

    private void startServer() {
        if (!this.server.isRunning()) {
            this.server.start();
            WireMock.configureFor((WireMock)new WireMock((Admin)this.server));
            this.exposePortInSystemProperties();
            log.info("Started the WireMock server on port {}", (Object)this.server.port());
        }
    }

    private void exposePortInSystemProperties() {
        if (this.configuration.getPortPropertyName() != null) {
            System.setProperty(this.configuration.getPortPropertyName(), String.valueOf(this.server.port()));
        }
    }

    private void injectStubsIntoTestClass(Object testInstance, Class<?> hierarchyLevelType) {
        for (Field field : hierarchyLevelType.getDeclaredFields()) {
            if (!this.stubs.containsKey(field.getType())) continue;
            this.injectStubIntoTestClass(testInstance, hierarchyLevelType, field);
        }
        if (hierarchyLevelType.getDeclaredAnnotation(WireMockStubs.class) == null) {
            this.injectStubsIntoTestClass(testInstance, hierarchyLevelType.getSuperclass());
        }
    }

    private void injectStubIntoTestClass(Object testInstance, Class<?> hierarchyLevelType, Field field) {
        WireMockStub stub = this.stubs.get(field.getType());
        boolean wasPreviouslyAccessible = field.canAccess(testInstance);
        field.setAccessible(true);
        try {
            field.set(testInstance, stub);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException("Failed to assign stub instance " + stub + " to the field " + hierarchyLevelType.getSimpleName() + "." + field.getName(), exception);
        }
        field.setAccessible(wasPreviouslyAccessible);
    }
}

