/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.factory;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.InvokerReference;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;

abstract class AbstractProxyFactory
implements ProxyFactory {
    private static final long serialVersionUID = 9212825902080759794L;
    public static final Method getInvoker;

    AbstractProxyFactory() {
    }

    public Invoker getInvoker(Object proxy) {
        InvokerReference ih = (InvokerReference)InvokerReference.class.cast(proxy);
        return ih.getInvoker();
    }

    static {
        try {
            getInvoker = InvokerReference.class.getMethod("getInvoker", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e.toString());
        }
    }

    static class CoincidentalInvocationHandlerAdapter
    implements Serializable {
        private static final long serialVersionUID = -7406561726778120065L;
        private Invoker invoker;

        public CoincidentalInvocationHandlerAdapter(Invoker invocationInterceptor) {
            this.invoker = invocationInterceptor;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(getInvoker)) {
                return this.invoker;
            }
            try {
                return this.invoker.invoke(proxy, method, args);
            }
            catch (UndeclaredThrowableException e) {
                throw e.getUndeclaredThrowable();
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

