/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.multicast;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.kit.ReflectionUtils;
import com.thoughtworks.proxy.toys.multicast.Multicast;
import com.thoughtworks.proxy.toys.multicast.Multicasting;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastingInvoker<T>
implements Invoker {
    private static final long serialVersionUID = 1L;
    private static final Method multicastTargetsDirect;
    private static final Method multicastTargetsIndirect;
    private static final Method getTargetsInArray;
    private static final Method getTargetsInTypedArray;
    private Class<?>[] types;
    private ProxyFactory proxyFactory;
    private Object[] targets;

    public MulticastingInvoker(Class<?>[] type, ProxyFactory proxyFactory, Object[] targets) {
        this.types = type;
        this.proxyFactory = proxyFactory;
        this.targets = targets;
    }

    public T proxy() {
        Class<?>[] classes;
        int i = this.types.length;
        while (--i >= 0 && this.types[i] != Multicast.class) {
        }
        if (i < 0) {
            classes = new Class[this.types.length + 1];
            if (classes.length > 1) {
                System.arraycopy(this.types, 0, classes, 1, this.types.length);
            }
            classes[0] = Multicast.class;
        } else {
            classes = this.types;
        }
        return this.proxyFactory.createProxy(this, classes);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (getTargetsInArray.equals(method)) {
            return this.targets;
        }
        if (getTargetsInTypedArray.equals(method)) {
            Object[] elements = (Object[])Object[].class.cast(Array.newInstance((Class)Class.class.cast(args[0]), this.targets.length));
            System.arraycopy(this.targets, 0, elements, 0, this.targets.length);
            return elements;
        }
        if (multicastTargetsDirect.equals(method)) {
            method = (Method)args[0];
            args = (Object[])args[1];
        } else if (multicastTargetsIndirect.equals(method)) {
            Object[] newArgs = args[2] == null ? new Object[]{} : (Object[])Object[].class.cast(args[2]);
            method = ReflectionUtils.getMatchingMethod((Class)Class.class.cast(args[0]), (String)String.class.cast(args[1]), newArgs);
            args = newArgs;
        }
        ArrayList<Object> invocationResults = new ArrayList<Object>();
        for (Object target : this.targets) {
            Object result;
            if (!method.getDeclaringClass().isInstance(target) || (result = method.invoke(target, args)) == null) continue;
            invocationResults.add(result);
        }
        if (invocationResults.size() == 0) {
            return null;
        }
        if (invocationResults.size() == 1) {
            return invocationResults.get(0);
        }
        if (method.getReturnType().equals(Byte.TYPE)) {
            return MulticastingInvoker.addBytes(invocationResults.toArray());
        }
        if (method.getReturnType().equals(Character.TYPE)) {
            return MulticastingInvoker.addChars(invocationResults.toArray());
        }
        if (method.getReturnType().equals(Short.TYPE)) {
            return MulticastingInvoker.addShorts(invocationResults.toArray());
        }
        if (method.getReturnType().equals(Integer.TYPE)) {
            return MulticastingInvoker.addIntegers(invocationResults.toArray());
        }
        if (method.getReturnType().equals(Long.TYPE)) {
            return MulticastingInvoker.addLongs(invocationResults.toArray());
        }
        if (method.getReturnType().equals(Float.TYPE)) {
            return MulticastingInvoker.addFloats(invocationResults.toArray());
        }
        if (method.getReturnType().equals(Double.TYPE)) {
            return MulticastingInvoker.addDoubles(invocationResults.toArray());
        }
        if (method.getReturnType().equals(Boolean.TYPE)) {
            return MulticastingInvoker.andBooleans(invocationResults.toArray());
        }
        return Multicasting.proxy(invocationResults.toArray()).build(this.proxyFactory);
    }

    private static Byte addBytes(Object[] args) {
        byte result = 0;
        for (Object arg : args) {
            result = (byte)(result + (Byte)Byte.class.cast(arg));
        }
        return result;
    }

    private static Character addChars(Object[] args) {
        char result = '\u0000';
        for (Object arg : args) {
            result = (char)(result + ((Character)Character.class.cast(arg)).charValue());
        }
        return Character.valueOf(result);
    }

    private static Short addShorts(Object[] args) {
        short result = 0;
        for (Object arg : args) {
            result = (short)(result + (Short)Short.class.cast(arg));
        }
        return result;
    }

    private static Integer addIntegers(Object[] args) {
        int result = 0;
        for (Object arg : args) {
            result += ((Integer)Integer.class.cast(arg)).intValue();
        }
        return result;
    }

    private static Long addLongs(Object[] args) {
        long result = 0L;
        for (Object arg : args) {
            result += ((Long)Long.class.cast(arg)).longValue();
        }
        return result;
    }

    private static Float addFloats(Object[] args) {
        float result = 0.0f;
        for (Object arg : args) {
            result += ((Float)Float.class.cast(arg)).floatValue();
        }
        return Float.valueOf(result);
    }

    private static Double addDoubles(Object[] args) {
        double result = 0.0;
        for (Object arg : args) {
            result += ((Double)Double.class.cast(arg)).doubleValue();
        }
        return result;
    }

    private static Boolean andBooleans(Object[] args) {
        for (Object arg : args) {
            if (((Boolean)Boolean.class.cast(arg)).booleanValue()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    static {
        try {
            multicastTargetsDirect = Multicast.class.getMethod("multicastTargets", Method.class, Object[].class);
            multicastTargetsIndirect = Multicast.class.getMethod("multicastTargets", Class.class, String.class, Object[].class);
            getTargetsInArray = Multicast.class.getMethod("getTargetsInArray", new Class[0]);
            getTargetsInTypedArray = Multicast.class.getMethod("getTargetsInArray", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e.toString());
        }
    }
}

