/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.pool;

import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.InvokerReference;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.kit.NoOperationResetter;
import com.thoughtworks.proxy.kit.ObjectReference;
import com.thoughtworks.proxy.kit.Resetter;
import com.thoughtworks.proxy.kit.SimpleReference;
import com.thoughtworks.proxy.toys.delegate.DelegatingInvoker;
import com.thoughtworks.proxy.toys.delegate.DelegationMode;
import com.thoughtworks.proxy.toys.pool.Poolable;
import com.thoughtworks.proxy.toys.pool.SerializationMode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pool<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Method returnInstanceToPool;
    private Class<?>[] types;
    private ProxyFactory factory;
    private transient Map<T, WeakReference<T>> busyInstances;
    private transient List<ObjectReference<T>> availableInstances;
    private Resetter<? super T> resetter;
    private SerializationMode serializationMode = SerializationMode.STANDARD;

    public static <T> PoolResettedBy<T> create(Class<T> type) {
        return new PoolResettedBy(new Pool<T>(type, new NoOperationResetter()));
    }

    public Pool(Class<T> type) {
        this(type, new NoOperationResetter(), new StandardProxyFactory());
    }

    public Pool(Class<T> type, Resetter<? super T> resetter) {
        this(type, resetter, new StandardProxyFactory());
    }

    public Pool(Class<T> type, ProxyFactory proxyFactory) {
        this(type, new NoOperationResetter(), proxyFactory, SerializationMode.STANDARD);
    }

    public Pool(Class<T> type, Resetter<? super T> resetter, ProxyFactory proxyFactory) {
        this(type, resetter, proxyFactory, SerializationMode.STANDARD);
    }

    public Pool(Class<T> type, Resetter<? super T> resetter, ProxyFactory proxyFactory, SerializationMode mode) {
        this();
        this.types = new Class[]{type, Poolable.class};
        this.resetter = resetter;
        this.factory = proxyFactory;
        this.serializationMode = mode;
    }

    private Pool() {
        this.busyInstances = new HashMap<T, WeakReference<T>>();
        this.availableInstances = new ArrayList<ObjectReference<T>>();
    }

    public synchronized void add(T ... instances) {
        if (instances != null) {
            for (T instance : instances) {
                if (instance == null) {
                    throw new NullPointerException();
                }
                this.availableInstances.add(new SimpleReference<T>(instance));
            }
            this.notifyAll();
        }
    }

    public synchronized T get() {
        Object result;
        if (this.availableInstances.size() > 0 || this.getAvailable() > 0) {
            ObjectReference<T> delegate = this.availableInstances.remove(0);
            result = new PoolingInvoker<T>(this, this.factory, delegate, DelegationMode.DIRECT).proxy();
            WeakReference<Object> weakReference = new WeakReference<Object>(result);
            this.busyInstances.put(delegate.get(), weakReference);
        } else {
            result = null;
        }
        return result;
    }

    public void release(T object) {
        Poolable poolable = (Poolable)Poolable.class.cast(object);
        PoolingInvoker invoker = (PoolingInvoker)PoolingInvoker.class.cast(((InvokerReference)InvokerReference.class.cast(poolable)).getInvoker());
        if (this != invoker.getPoolInstance()) {
            throw new IllegalArgumentException("Release object from different pool");
        }
        poolable.returnInstanceToPool();
    }

    public synchronized int getAvailable() {
        if (this.busyInstances.size() > 0) {
            ArrayList<T> freedInstances = new ArrayList<T>();
            for (T target : this.busyInstances.keySet()) {
                WeakReference<T> ref = this.busyInstances.get(target);
                if (ref.get() != null) continue;
                freedInstances.add(target);
            }
            ArrayList resettedInstances = new ArrayList();
            for (Object element : freedInstances) {
                this.busyInstances.remove(element);
                if (!this.resetter.reset(element)) continue;
                resettedInstances.add(new SimpleReference(element));
            }
            this.availableInstances.addAll(resettedInstances);
            if (freedInstances.size() > 0) {
                this.notifyAll();
            }
        }
        return this.availableInstances.size();
    }

    public synchronized int size() {
        return this.availableInstances.size() + this.busyInstances.size();
    }

    private synchronized void returnInstanceToPool(ObjectReference<T> reference) {
        this.busyInstances.remove(reference.get());
        if (this.resetter.reset(reference.get())) {
            this.availableInstances.add(reference);
        }
        this.notifyAll();
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ArrayList<ObjectReference<T>> instances = new ArrayList<ObjectReference<T>>(this.availableInstances);
        Iterator<T> iter = this.busyInstances.keySet().iterator();
        while (iter.hasNext()) {
            instances.add(new SimpleReference<T>(iter.next()));
        }
        SerializationMode mode = this.serializationMode;
        if (mode == SerializationMode.FORCE) {
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                ObjectOutputStream testStream = new ObjectOutputStream(buffer);
                testStream.writeObject(instances);
                testStream.close();
                mode = SerializationMode.STANDARD;
            }
            catch (NotSerializableException e) {
                mode = SerializationMode.NONE;
            }
        }
        if (mode == SerializationMode.STANDARD) {
            out.writeObject(instances);
        } else {
            out.writeObject(new ArrayList());
        }
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        List list;
        in.defaultReadObject();
        this.availableInstances = list = (List)List.class.cast(in.readObject());
        this.busyInstances = new HashMap<T, WeakReference<T>>();
    }

    static {
        try {
            returnInstanceToPool = Poolable.class.getMethod("returnInstanceToPool", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PoolingInvoker<T>
    extends DelegatingInvoker<T> {
        private static final long serialVersionUID = 1L;
        private Pool<T> pool;

        protected PoolingInvoker(Pool<T> pool, ProxyFactory proxyFactory, ObjectReference<T> delegateReference, DelegationMode delegationMode) {
            super(proxyFactory, delegateReference, delegationMode);
            this.pool = pool;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            if (method.equals(returnInstanceToPool)) {
                this.returnInstanceToPool();
                result = Void.TYPE;
            } else {
                result = super.invoke(proxy, method, args);
            }
            return result;
        }

        public void returnInstanceToPool() {
            ((Pool)this.pool).returnInstanceToPool(this.getDelegateReference());
        }

        protected T proxy() {
            return this.getProxyFactory().createProxy(this, ((Pool)this.pool).types);
        }

        private Pool<T> getPoolInstance() {
            return this.pool;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PoolModeOrBuild<T>
    extends PoolBuild<T> {
        private PoolModeOrBuild(Pool<T> pool) {
            super(pool);
        }

        public PoolBuild<T> mode(SerializationMode serializationMode) {
            this.pool.serializationMode = serializationMode;
            return new PoolBuild(this.pool);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PoolWith<T>
    extends PoolModeOrBuild<T> {
        private PoolWith(Pool<T> pool) {
            super(pool);
        }

        public PoolModeOrBuild<T> with(T ... instances) {
            this.pool.add(instances);
            return new PoolModeOrBuild(this.pool);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PoolResettedBy<T>
    extends PoolWith<T> {
        private PoolResettedBy(Pool<T> pool) {
            super(pool);
        }

        public PoolWith<T> resettedBy(Resetter<? super T> resetter) {
            this.pool.resetter = resetter;
            return new PoolWith(this.pool);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PoolBuild<T> {
        protected Pool<T> pool;

        private PoolBuild(Pool<T> pool) {
            this.pool = pool;
        }

        public Pool<T> build() {
            return this.build(new StandardProxyFactory());
        }

        public Pool<T> build(ProxyFactory factory) {
            ((Pool)this.pool).factory = factory;
            return this.pool;
        }
    }
}

